/*
 * Decompiled with CFR 0.152.
 */
package com.smldb2.demo.controllers;

import com.smldb2.demo.services.ActeAffectationService;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/actes/affectation"})
@CrossOrigin(origins={"*"})
public class ActeAffectationController {
    @Autowired
    private ActeAffectationService affectationService;

    @PostMapping(value={"/tous"})
    public ResponseEntity<Map<String, Object>> affecterTousLesActes() {
        try {
            Map<String, Object> resultat = this.affectationService.affecterTousLesActes();
            return ResponseEntity.ok(resultat);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body(Map.of("erreur", "Erreur lors de l'affectation: " + e.getMessage()));
        }
    }

    @PostMapping(value={"/remboursement/{refBsPhys}"})
    public ResponseEntity<Map<String, Object>> affecterActesPourRemboursement(@PathVariable String refBsPhys) {
        try {
            Map<String, Object> resultat = this.affectationService.affecterActesPourRemboursement(refBsPhys);
            if (resultat.containsKey("erreur")) {
                return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body(resultat);
            }
            return ResponseEntity.ok(resultat);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body(Map.of("erreur", "Erreur lors de l'affectation: " + e.getMessage()));
        }
    }

    @PostMapping(value={"/acte/{idActe}/remboursement/{refBsPhys}"})
    public ResponseEntity<Map<String, Object>> affecterActeUnique(@PathVariable Long idActe, @PathVariable String refBsPhys) {
        try {
            Map<String, Object> resultat = this.affectationService.affecterActeUnique(idActe, refBsPhys);
            if (resultat.containsKey("erreur")) {
                return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body(resultat);
            }
            return ResponseEntity.ok(resultat);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body(Map.of("erreur", "Erreur lors de l'affectation: " + e.getMessage()));
        }
    }

    @GetMapping(value={"/etat"})
    public ResponseEntity<Map<String, Object>> verifierEtatAffectation() {
        try {
            Map<String, Object> etat = this.affectationService.verifierEtatAffectation();
            return ResponseEntity.ok(etat);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body(Map.of("erreur", "Erreur lors de la v\u00e9rification: " + e.getMessage()));
        }
    }

    @DeleteMapping(value={"/acte/{idActe}"})
    public ResponseEntity<Map<String, Object>> desaffecterActe(@PathVariable Long idActe) {
        try {
            Map<String, Object> resultat = this.affectationService.desaffecterActe(idActe);
            if (resultat.containsKey("erreur")) {
                return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body(resultat);
            }
            return ResponseEntity.ok(resultat);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body(Map.of("erreur", "Erreur lors de la d\u00e9saffectation: " + e.getMessage()));
        }
    }
}

