/*
 * Decompiled with CFR 0.152.
 */
package com.smldb2.demo.controllers;

import com.smldb2.demo.DTO.UnifiedLoginResponse;
import com.smldb2.demo.Entity.User;
import com.smldb2.demo.services.AuthService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/auth"})
public class AuthController {
    @Autowired
    private AuthService authService;

    @PostMapping(value={"/login"})
    public ResponseEntity<UnifiedLoginResponse> login(@RequestBody User loginRequest) {
        UnifiedLoginResponse response = this.authService.login(loginRequest.getPersoId(), loginRequest.getPersoPassed());
        if (response.isSuccess()) {
            return ResponseEntity.ok((Object)response);
        }
        return ResponseEntity.status((int)401).body((Object)response);
    }

    @GetMapping(value={"/login"})
    public ResponseEntity<String> testLogin() {
        return ResponseEntity.ok((Object)"API is reachable! Use POST to login.");
    }

    @GetMapping(value={"/test"})
    public ResponseEntity<String> test() {
        return ResponseEntity.ok((Object)"Spring Boot API is running!");
    }
}

