/*
 * Decompiled with CFR 0.152.
 */
package com.smldb2.demo.controllers;

import com.smldb2.demo.DTO.BordereauStatsDTO;
import com.smldb2.demo.DTO.GlobalStatsDTO;
import com.smldb2.demo.Entity.Bordereau;
import com.smldb2.demo.services.BordereauService;
import java.util.List;
import java.util.Optional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/bordereaux"})
@CrossOrigin(origins={"**"})
public class BordereauController {
    private final BordereauService bordereauService;

    public BordereauController(BordereauService bordereauService) {
        this.bordereauService = bordereauService;
    }

    @GetMapping
    public ResponseEntity<List<Bordereau>> getAllBordereaux() {
        return ResponseEntity.ok(this.bordereauService.getAllBordereaux());
    }

    @GetMapping(value={"/by-prefix"})
    public ResponseEntity<List<Bordereau>> getBordereauxByPrefix(@RequestParam String prefix) {
        return ResponseEntity.ok(this.bordereauService.getBordereauxByPrefix(prefix));
    }

    @GetMapping(value={"/{refBordereau}"})
    public ResponseEntity<Bordereau> getBordereauAvecRemboursements(@PathVariable String refBordereau) {
        Optional<Bordereau> bordereau = this.bordereauService.getBordereauAvecRemboursements(refBordereau);
        return bordereau.map(ResponseEntity::ok).orElse(ResponseEntity.notFound().build());
    }

    @GetMapping(value={"/stats/global"})
    public ResponseEntity<GlobalStatsDTO> getGlobalStats(@RequestParam(required=false) String prefix) {
        return ResponseEntity.ok((Object)this.bordereauService.getGlobalBordereauxStats(prefix));
    }

    @GetMapping(value={"/stats/{refBordereau}"})
    public ResponseEntity<BordereauStatsDTO> getBordereauStats(@PathVariable String refBordereau) {
        try {
            BordereauStatsDTO stats = this.bordereauService.getBordereauStats(refBordereau);
            return ResponseEntity.ok((Object)stats);
        }
        catch (RuntimeException e) {
            return ResponseEntity.notFound().build();
        }
    }
}

