/*
 * Decompiled with CFR 0.152.
 */
package com.smldb2.demo.controllers;

import com.smldb2.demo.Entity.BordereauOuvert;
import com.smldb2.demo.services.BordereauOuvertService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/bordereau-ouvert"})
@CrossOrigin(origins={"**"})
public class BordereauOuvertController {
    @Autowired
    private BordereauOuvertService bordereauOuvertService;

    @GetMapping
    public ResponseEntity<List<BordereauOuvert>> getAllBordereauOuverts() {
        List<BordereauOuvert> bordereauOuverts = this.bordereauOuvertService.getAllBordereauOuverts();
        return ResponseEntity.ok(bordereauOuverts);
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<BordereauOuvert> getBordereauOuvertById(@PathVariable String id) {
        return this.bordereauOuvertService.getBordereauOuvertById(id).map(ResponseEntity::ok).orElse(ResponseEntity.notFound().build());
    }

    @GetMapping(value={"/entite/{codeEntite}"})
    public ResponseEntity<List<BordereauOuvert>> getBordereauOuvertsByCodeEntite(@PathVariable String codeEntite) {
        List<BordereauOuvert> bordereauOuverts = this.bordereauOuvertService.getBordereauOuvertsByCodeEntite(codeEntite);
        return ResponseEntity.ok(bordereauOuverts);
    }
}

