/*
 * Decompiled with CFR 0.152.
 */
package com.smldb2.demo.controllers;

import com.smldb2.demo.Entity.Bssaisis;
import com.smldb2.demo.services.BssaisislService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/bssaisis"})
@CrossOrigin(origins={"**"})
public class BssaisislController {
    @Autowired
    private BssaisislService bssaisislService;

    @GetMapping
    public ResponseEntity<List<Bssaisis>> getAllBssaisis() {
        List<Bssaisis> bssaisis = this.bssaisislService.getAllBssaisis();
        return ResponseEntity.ok(bssaisis);
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<Bssaisis> getBssaisislById(@PathVariable String id) {
        return this.bssaisislService.getBssaisislById(id).map(ResponseEntity::ok).orElse(ResponseEntity.notFound().build());
    }

    @GetMapping(value={"/matricule/{matricule}"})
    public ResponseEntity<List<Bssaisis>> getBssaisislByMatricule(@PathVariable String matricule) {
        List<Bssaisis> bssaisis = this.bssaisislService.getBssaisislByMatricule(matricule);
        return ResponseEntity.ok(bssaisis);
    }

    @GetMapping(value={"/site/{codeSite}"})
    public ResponseEntity<List<Bssaisis>> getBssaisislByCodeSite(@PathVariable String codeSite) {
        List<Bssaisis> bssaisis = this.bssaisislService.getBssaisislByCodeSite(codeSite);
        return ResponseEntity.ok(bssaisis);
    }
}

