/*
 * Decompiled with CFR 0.152.
 */
package com.smldb2.demo.controllers;

import com.smldb2.demo.DTO.DocumentInfo;
import com.smldb2.demo.services.EmailService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/complement-info"})
@CrossOrigin(origins={"**"})
public class ComplementInfoController {
    @Autowired
    private EmailService emailService;
    @Value(value="${app.email.recipient}")
    private String recipientEmail;

    @PostMapping(value={"/send-email-multiple"})
    public ResponseEntity<?> sendComplementInfoMultiple(@RequestParam(value="userPersoId") String userPersoId, @RequestParam(value="userName") String userName, @RequestParam(value="userEmail") String userEmail, @RequestParam(value="documentTypes") String[] documentTypes, @RequestParam(value="files") MultipartFile[] files) {
        try {
            if (files == null || files.length == 0 || documentTypes.length != files.length) {
                return ResponseEntity.badRequest().body(Map.of("error", "Chaque fichier doit avoir un type associ\u00e9"));
            }
            ArrayList<DocumentInfo> documents = new ArrayList<DocumentInfo>();
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].getContentType().equals("application/pdf")) {
                    return ResponseEntity.badRequest().body(Map.of("error", "Seuls les fichiers PDF sont accept\u00e9s"));
                }
                if (files[i].getSize() > 0x500000L) {
                    return ResponseEntity.badRequest().body(Map.of("error", "La taille du fichier " + files[i].getOriginalFilename() + " d\u00e9passe 5MB"));
                }
                documents.add(new DocumentInfo(documentTypes[i], files[i]));
            }
            boolean sent = this.emailService.sendComplementInfoEmailMultiple(this.recipientEmail, userPersoId, userName, userEmail, documents);
            if (sent) {
                HashMap<String, Object> response = new HashMap<String, Object>();
                response.put("success", true);
                response.put("message", "Documents envoy\u00e9s avec succ\u00e8s ");
                response.put("filesCount", files.length);
                return ResponseEntity.ok(response);
            }
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body(Map.of("error", "Erreur lors de l'envoi de l'email"));
        }
        catch (Exception e) {
            e.printStackTrace();
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body(Map.of("error", "Erreur serveur: " + e.getMessage()));
        }
    }
}

