/*
 * Decompiled with CFR 0.152.
 */
package com.smldb2.demo.controllers;

import com.smldb2.demo.DTO.FamilleDTO;
import com.smldb2.demo.Entity.Famille;
import com.smldb2.demo.Entity.TypePrestataire;
import com.smldb2.demo.repositories.FamilleRepository;
import com.smldb2.demo.services.FamilleService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/familles"})
@CrossOrigin(origins={"**"})
public class FamilleController {
    private final FamilleService familleService;
    private final FamilleRepository familleRepository;

    @GetMapping(value={"/debug-count"})
    public String debugCount() {
        long count = this.familleRepository.count();
        return "Familles trouv\u00e9es = " + count;
    }

    @Autowired
    public FamilleController(FamilleService familleService, FamilleRepository familleRepository) {
        this.familleService = familleService;
        this.familleRepository = familleRepository;
    }

    @GetMapping
    public List<Famille> getAllFamilles() {
        return this.familleRepository.findAll();
    }

    @GetMapping(value={"/count"})
    public long countFamilles() {
        return this.familleRepository.count();
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<Famille> getFamilleById(@PathVariable String id) {
        return this.familleService.getFamilleById(id).map(ResponseEntity::ok).orElse(ResponseEntity.notFound().build());
    }

    @GetMapping(value={"/user/{persoId}"})
    public ResponseEntity<List<Famille>> getFamillesByPersoId(@PathVariable String persoId) {
        List<Famille> familles = this.familleService.getFamillesByPersoId(persoId);
        return ResponseEntity.ok(familles);
    }

    @GetMapping(value={"/type/{type}"})
    public ResponseEntity<List<Famille>> getFamillesByType(@PathVariable TypePrestataire type) {
        List<Famille> familles = this.familleService.getFamillesByType(type);
        return ResponseEntity.ok(familles);
    }

    @GetMapping(value={"/debug-full"})
    public ResponseEntity<Map<String, Object>> debugFull() {
        List allFamilles = this.familleRepository.findAll();
        HashMap<String, Object> debug = new HashMap<String, Object>();
        debug.put("totalFromRepo", allFamilles.size());
        debug.put("sampleData", allFamilles.stream().limit(5L).collect(Collectors.toList()));
        return ResponseEntity.ok(debug);
    }

    @GetMapping(value={"/with-pagination"})
    public ResponseEntity<Map<String, Object>> getAllFamillesWithPagination(@RequestParam(defaultValue="0") int page, @RequestParam(defaultValue="1000") int size) {
        PageRequest pageable = PageRequest.of((int)page, (int)size);
        Page famillePage = this.familleRepository.findAll((Pageable)pageable);
        List familleDTOs = famillePage.getContent().stream().map(this::convertToDTO).collect(Collectors.toList());
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("content", familleDTOs);
        response.put("totalElements", famillePage.getTotalElements());
        response.put("totalPages", famillePage.getTotalPages());
        return ResponseEntity.ok(response);
    }

    private FamilleDTO convertToDTO(Famille famille) {
        FamilleDTO dto = new FamilleDTO();
        dto.setPrenomPrestataire(famille.getPrenomPrestataire());
        dto.setTypPrestataire(famille.getTypPrestataire());
        dto.setPersoId(famille.getPersoId());
        dto.setDatNais(famille.getDatNais());
        dto.setSexe(famille.getSexe());
        return dto;
    }
}

