/*
 * Decompiled with CFR 0.152.
 */
package com.smldb2.demo.controllers;

import com.smldb2.demo.Entity.Prestataire;
import com.smldb2.demo.services.PrestataireService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/prestataires"})
@CrossOrigin(origins={"**"})
public class PrestataireController {
    @Autowired
    private PrestataireService prestataireService;

    @PostMapping(value={"/create"})
    public ResponseEntity<Prestataire> creerPrestataire(@RequestBody Prestataire prestataire) {
        Prestataire created = this.prestataireService.creerPrestataire(prestataire);
        return ResponseEntity.ok((Object)created);
    }

    @GetMapping(value={"/all"})
    public ResponseEntity<List<Prestataire>> getAllPrestataires() {
        List<Prestataire> prestataires = this.prestataireService.getAllPrestataires();
        return ResponseEntity.ok(prestataires);
    }

    @GetMapping(value={"/{persoId}"})
    public ResponseEntity<Prestataire> getPrestataireById(@PathVariable String persoId) {
        Optional<Prestataire> prestataire = this.prestataireService.getPrestataireById(persoId);
        return prestataire.map(ResponseEntity::ok).orElse(ResponseEntity.notFound().build());
    }

    @GetMapping(value={"/role/{role}"})
    public ResponseEntity<List<Prestataire>> getPrestatairesByRole(@PathVariable String role) {
        List<Prestataire> prestataires = this.prestataireService.getPrestatairesByRole(role);
        return ResponseEntity.ok(prestataires);
    }

    @PutMapping(value={"/update/{persoId}"})
    public ResponseEntity<Prestataire> updatePrestataire(@PathVariable String persoId, @RequestBody Prestataire prestataire) {
        Prestataire updated = this.prestataireService.updatePrestataire(persoId, prestataire);
        if (updated != null) {
            return ResponseEntity.ok((Object)updated);
        }
        return ResponseEntity.notFound().build();
    }

    @DeleteMapping(value={"/delete/{persoId}"})
    public ResponseEntity<String> deletePrestataire(@PathVariable String persoId) {
        boolean deleted = this.prestataireService.deletePrestataire(persoId);
        if (deleted) {
            return ResponseEntity.ok((Object)"Prestataire supprim\u00e9 avec succ\u00e8s");
        }
        return ResponseEntity.notFound().build();
    }
}

