/*
 * Decompiled with CFR 0.152.
 */
package com.smldb2.demo.controllers;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.smldb2.demo.Entity.Famille;
import com.smldb2.demo.Entity.RapportContreVisite;
import com.smldb2.demo.Entity.Remboursement;
import com.smldb2.demo.Entity.User;
import com.smldb2.demo.services.RapportContreVisiteService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/rapports"})
@CrossOrigin(origins={"**"})
public class RapportContreVisiteController {
    @Autowired
    private RapportContreVisiteService rapportService;
    @Autowired
    private ObjectMapper objectMapper;

    @GetMapping(value={"/prestataire/{prestataireId}"})
    public ResponseEntity<List<Map<String, String>>> getRapportsAvecType(@PathVariable String prestataireId) {
        return ResponseEntity.ok(this.rapportService.getRapportsAvecType(prestataireId));
    }

    @GetMapping(value={"/adherents"})
    public ResponseEntity<List<User>> getAllAdherents() {
        return ResponseEntity.ok(this.rapportService.getAllAdherents());
    }

    @GetMapping(value={"/famille/{persoId}"})
    public ResponseEntity<List<Famille>> getFamilleByUser(@PathVariable String persoId) {
        return ResponseEntity.ok(this.rapportService.getFamilleByUser(persoId));
    }

    @GetMapping(value={"/remboursements/{persoId}"})
    public ResponseEntity<List<Remboursement>> getRemboursementsByUser(@PathVariable String persoId) {
        return ResponseEntity.ok(this.rapportService.getRemboursementsByUser(persoId));
    }

    @GetMapping(value={"/remboursements-by-cin/{cin}"})
    public ResponseEntity<List<Remboursement>> getRemboursementsByCin(@PathVariable String cin) {
        User adherent = this.rapportService.getAdherentByMatricule(cin);
        if (adherent == null) {
            return ResponseEntity.notFound().build();
        }
        return ResponseEntity.ok(this.rapportService.getRemboursementsByUser(adherent.getPersoId()));
    }

    @GetMapping(value={"/adherent/{matricule}"})
    public ResponseEntity<User> getAdherentByMatricule(@PathVariable String matricule) {
        User adherent = this.rapportService.getAdherentByMatricule(matricule);
        if (adherent != null) {
            return ResponseEntity.ok((Object)adherent);
        }
        return ResponseEntity.notFound().build();
    }

    @GetMapping(value={"/beneficiaires/{refBsPhys}"})
    public ResponseEntity<Map<String, Object>> getBeneficiaires(@PathVariable String refBsPhys) {
        try {
            Optional<Remboursement> rembOpt = this.rapportService.getRemboursementsByUser("").stream().filter(r -> r.getRefBsPhys().equals(refBsPhys)).findFirst();
            if (!rembOpt.isPresent()) {
                HashMap<String, Object> error = new HashMap<String, Object>();
                error.put("success", false);
                error.put("message", "Remboursement introuvable");
                return ResponseEntity.badRequest().body(error);
            }
            Remboursement remboursement = rembOpt.get();
            String persoId = remboursement.getPersoId();
            Optional<User> userOpt = Optional.ofNullable(this.rapportService.getAllAdherents().stream().filter(u -> u.getPersoId().equals(persoId)).findFirst().orElse(null));
            if (!userOpt.isPresent()) {
                HashMap<String, Object> error = new HashMap<String, Object>();
                error.put("success", false);
                error.put("message", "Adh\u00e9rent introuvable");
                return ResponseEntity.badRequest().body(error);
            }
            User user = userOpt.get();
            ArrayList beneficiaires = new ArrayList();
            HashMap<String, String> adherentMap = new HashMap<String, String>();
            adherentMap.put("id", user.getPersoId());
            adherentMap.put("nom", user.getPersoName());
            adherentMap.put("type", "ADHERENT");
            beneficiaires.add(adherentMap);
            List<Famille> familles = this.rapportService.getFamilleByUser(persoId);
            for (Famille famille : familles) {
                HashMap<String, String> familleMap = new HashMap<String, String>();
                familleMap.put("id", famille.getPrenomPrestataire());
                familleMap.put("nom", famille.getPrenomPrestataire());
                familleMap.put("type", famille.getTypPrestataire().name());
                beneficiaires.add(familleMap);
            }
            HashMap<String, Serializable> response = new HashMap<String, Serializable>();
            response.put("success", Boolean.valueOf(true));
            response.put("beneficiaires", beneficiaires);
            return ResponseEntity.ok(response);
        }
        catch (Exception e) {
            HashMap<String, Object> error = new HashMap<String, Object>();
            error.put("success", false);
            error.put("message", "Erreur: " + e.getMessage());
            return ResponseEntity.badRequest().body(error);
        }
    }

    @PostMapping(value={"/create"}, consumes={"multipart/form-data"})
    public ResponseEntity<Map<String, Object>> creerRapport(@RequestParam(value="matriculeAdherent") String matriculeAdherent, @RequestParam(value="refBsPhys") String refBsPhys, @RequestParam(value="prestataireId") String prestataireId, @RequestPart(value="rapport") String rapportJson, @RequestPart(value="image", required=false) MultipartFile image) {
        System.out.println("\u2705 Requ\u00eate re\u00e7ue");
        System.out.println("\ud83d\udcc4 Matricule : " + matriculeAdherent);
        System.out.println("\ud83d\udcc4 RefBsPhys : " + refBsPhys);
        System.out.println("\ud83d\udcc4 PrestataireId : " + prestataireId);
        System.out.println("\ud83d\uddbc\ufe0f Image : " + (image != null ? image.getOriginalFilename() : "Aucune"));
        try {
            RapportContreVisite rapport = (RapportContreVisite)this.objectMapper.readValue(rapportJson, RapportContreVisite.class);
            System.out.println("\ud83d\udcc4 Type rapport : " + rapport.getTypeRapport());
            Map<String, Object> response = this.rapportService.creerRapportParMatricule(matriculeAdherent, refBsPhys, prestataireId, image, rapport);
            if (((Boolean)response.get("success")).booleanValue()) {
                return ResponseEntity.ok(response);
            }
            return ResponseEntity.badRequest().body(response);
        }
        catch (Exception e) {
            e.printStackTrace();
            HashMap<String, Object> errorResponse = new HashMap<String, Object>();
            errorResponse.put("success", false);
            errorResponse.put("message", "Erreur lors de la cr\u00e9ation du rapport: " + e.getMessage());
            return ResponseEntity.badRequest().body(errorResponse);
        }
    }

    @GetMapping(value={"/beneficiaire/{refBsPhys}"})
    public ResponseEntity<Map<String, Object>> getBeneficiaire(@PathVariable String refBsPhys) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        try {
            Map<String, String> beneficiaire = this.rapportService.getBeneficiaireParRefBsPhys(refBsPhys);
            response.put("success", true);
            response.put("beneficiaire", beneficiaire);
            return ResponseEntity.ok(response);
        }
        catch (Exception e) {
            response.put("success", false);
            response.put("message", e.getMessage());
            return ResponseEntity.badRequest().body(response);
        }
    }

    @GetMapping(value={"/beneficiaire-id/{beneficiaireId}"})
    public ResponseEntity<List<Map<String, Object>>> getRapportsByBeneficiaireId(@PathVariable String beneficiaireId) {
        List<Map<String, Object>> rapports = this.rapportService.getRapportsByBeneficiaireId(beneficiaireId);
        if (rapports.isEmpty()) {
            return ResponseEntity.noContent().build();
        }
        return ResponseEntity.ok(rapports);
    }

    @GetMapping(value={"/prestataire/details/{prestataireId}"})
    public ResponseEntity<List<Map<String, Object>>> getRapportsDetailsByPrestataire(@PathVariable String prestataireId) {
        List<Map<String, Object>> rapports = this.rapportService.getRapportsDetailsByPrestataire(prestataireId);
        if (rapports.isEmpty()) {
            return ResponseEntity.noContent().build();
        }
        return ResponseEntity.ok(rapports);
    }
}

