/*
 * Decompiled with CFR 0.152.
 */
package com.smldb2.demo.controllers;

import com.smldb2.demo.DTO.ReclamationDTO;
import com.smldb2.demo.Entity.Remboursement;
import com.smldb2.demo.services.ReclamationService;
import java.lang.constant.Constable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/reclamations"})
@CrossOrigin(origins={"**"})
public class ReclamationController {
    @Autowired
    private ReclamationService reclamationService;

    @PostMapping
    public ResponseEntity<?> createReclamation(@RequestBody ReclamationDTO reclamationDTO) {
        try {
            ReclamationDTO createdReclamation = this.reclamationService.createReclamation(reclamationDTO);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)createdReclamation);
        }
        catch (RuntimeException e) {
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("error", e.getMessage());
            if (e.getMessage().startsWith("LIMITE_ATTEINTE:")) {
                return ResponseEntity.status((HttpStatusCode)HttpStatus.FORBIDDEN).body(error);
            }
            return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body(error);
        }
    }

    @GetMapping(value={"/count/{refBsPhys}"})
    public ResponseEntity<Map<String, Object>> getReclamationCount(@PathVariable String refBsPhys) {
        int count = this.reclamationService.countReclamationsByRefBsPhys(refBsPhys);
        boolean canCreate = this.reclamationService.canCreateReclamation(refBsPhys);
        HashMap<String, Constable> response = new HashMap<String, Constable>();
        response.put("count", Integer.valueOf(count));
        response.put("maxAllowed", Integer.valueOf(2));
        response.put("canCreate", Boolean.valueOf(canCreate));
        response.put("remaining", Integer.valueOf(Math.max(0, 2 - count)));
        return ResponseEntity.ok(response);
    }

    @GetMapping(value={"/user/{persoId}"})
    public ResponseEntity<List<ReclamationDTO>> getReclamationsByUser(@PathVariable String persoId) {
        List<ReclamationDTO> reclamations = this.reclamationService.getReclamationsByUser(persoId);
        return ResponseEntity.ok(reclamations);
    }

    @GetMapping(value={"/{numReclamation}"})
    public ResponseEntity<?> getReclamationById(@PathVariable Long numReclamation) {
        try {
            ReclamationDTO reclamation = this.reclamationService.getReclamationById(numReclamation);
            return ResponseEntity.ok((Object)reclamation);
        }
        catch (RuntimeException e) {
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("error", e.getMessage());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body(error);
        }
    }

    @GetMapping(value={"/remboursement/{refBsPhys}"})
    public ResponseEntity<List<ReclamationDTO>> getReclamationsByRefBsPhys(@PathVariable String refBsPhys) {
        List<ReclamationDTO> reclamations = this.reclamationService.getReclamationsByRefBsPhys(refBsPhys);
        return ResponseEntity.ok(reclamations);
    }

    @GetMapping(value={"/exists/{refBsPhys}"})
    public ResponseEntity<Map<String, Boolean>> hasReclamation(@PathVariable String refBsPhys) {
        boolean exists = this.reclamationService.hasReclamation(refBsPhys);
        HashMap<String, Boolean> response = new HashMap<String, Boolean>();
        response.put("exists", exists);
        return ResponseEntity.ok(response);
    }

    @GetMapping(value={"/remboursements/{persoId}"})
    public ResponseEntity<List<Remboursement>> getRemboursementsByUser(@PathVariable String persoId) {
        List<Remboursement> remboursements = this.reclamationService.getRemboursementsByUser(persoId);
        return ResponseEntity.ok(remboursements);
    }

    @DeleteMapping(value={"/{numReclamation}"})
    public ResponseEntity<?> deleteReclamation(@PathVariable Long numReclamation) {
        try {
            this.reclamationService.deleteReclamation(numReclamation);
            HashMap<String, String> response = new HashMap<String, String>();
            response.put("message", "R\u00e9clamation supprim\u00e9e avec succ\u00e8s");
            return ResponseEntity.ok(response);
        }
        catch (RuntimeException e) {
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("error", e.getMessage());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body(error);
        }
    }

    @PutMapping(value={"/{numReclamation}/response"})
    public ResponseEntity<?> updateReclamationResponse(@PathVariable Long numReclamation, @RequestBody Map<String, String> requestBody) {
        try {
            String response = requestBody.get("response");
            ReclamationDTO updatedReclamation = this.reclamationService.updateReclamationResponse(numReclamation, response);
            return ResponseEntity.ok((Object)updatedReclamation);
        }
        catch (RuntimeException e) {
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("error", e.getMessage());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body(error);
        }
    }

    @GetMapping
    public ResponseEntity<List<ReclamationDTO>> getAllReclamations() {
        return ResponseEntity.ok(List.of());
    }
}

