/*
 * Decompiled with CFR 0.152.
 */
package com.smldb2.demo.controllers;

import com.smldb2.demo.Entity.Remboursement;
import com.smldb2.demo.services.RemboursementService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/remboursements"})
@CrossOrigin(origins={"**"})
public class RemboursementController {
    @Autowired
    private RemboursementService remboursementService;

    @GetMapping(value={"/details/{refBsPhys}"})
    public ResponseEntity<Remboursement> getRemboursementWithActes(@PathVariable String refBsPhys) {
        return this.remboursementService.getRemboursementWithActes(refBsPhys).map(ResponseEntity::ok).orElse(ResponseEntity.notFound().build());
    }

    @GetMapping
    public ResponseEntity<List<Remboursement>> getAllRemboursements() {
        List<Remboursement> remboursements = this.remboursementService.getAllRemboursements();
        return ResponseEntity.ok(remboursements);
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<Remboursement> getRemboursementById(@PathVariable String id) {
        return this.remboursementService.getRemboursementById(id).map(ResponseEntity::ok).orElse(ResponseEntity.notFound().build());
    }

    @GetMapping(value={"/user/{persoId}"})
    public ResponseEntity<List<Remboursement>> getRemboursementsByPersoId(@PathVariable String persoId) {
        List<Remboursement> remboursements = this.remboursementService.getRemboursementsByPersoId(persoId);
        return ResponseEntity.ok(remboursements);
    }

    @GetMapping(value={"/status/{status}"})
    public ResponseEntity<List<Remboursement>> getRemboursementsByStatus(@PathVariable String status) {
        List<Remboursement> remboursements = this.remboursementService.getRemboursementsByStatus(status);
        return ResponseEntity.ok(remboursements);
    }

    @GetMapping(value={"/bordereau/{refBordereau}"})
    public ResponseEntity<List<Remboursement>> getRemboursementsByBordereau(@PathVariable String refBordereau) {
        List<Remboursement> remboursements = this.remboursementService.getRemboursementsByBordereau(refBordereau);
        return ResponseEntity.ok(remboursements);
    }
}

