/*
 * Decompiled with CFR 0.152.
 */
package com.smldb2.demo.controllers;

import com.smldb2.demo.Entity.Rib;
import com.smldb2.demo.services.RibService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/rib"})
@CrossOrigin(origins={"**"})
public class RibController {
    @Autowired
    private RibService ribService;

    @GetMapping
    public ResponseEntity<List<Rib>> getAllRibs() {
        List<Rib> ribs = this.ribService.getAllRibs();
        return ResponseEntity.ok(ribs);
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<Rib> getRibById(@PathVariable Integer id) {
        return this.ribService.getRibById(id).map(ResponseEntity::ok).orElse(ResponseEntity.notFound().build());
    }

    @GetMapping(value={"/user/{persoId}"})
    public ResponseEntity<List<Rib>> getRibsByPersoId(@PathVariable String persoId) {
        List<Rib> ribs = this.ribService.getRibsByPersoId(persoId);
        return ResponseEntity.ok(ribs);
    }

    @GetMapping(value={"/exported/{exported}"})
    public ResponseEntity<List<Rib>> getRibsByExported(@PathVariable String exported) {
        List<Rib> ribs = this.ribService.getRibsByExported(exported);
        return ResponseEntity.ok(ribs);
    }
}

