/*
 * Decompiled with CFR 0.152.
 */
package com.smldb2.demo.controllers;

import com.smldb2.demo.Entity.Site;
import com.smldb2.demo.services.SiteService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/sites"})
@CrossOrigin(origins={"**"})
public class SiteController {
    @Autowired
    private SiteService siteService;

    @GetMapping
    public ResponseEntity<List<Site>> getAllSites() {
        List<Site> sites = this.siteService.getAllSites();
        return ResponseEntity.ok(sites);
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<Site> getSiteById(@PathVariable String id) {
        return this.siteService.getSiteById(id).map(ResponseEntity::ok).orElse(ResponseEntity.notFound().build());
    }

    @GetMapping(value={"/entite/{codeEntite}"})
    public ResponseEntity<List<Site>> getSitesByCodeEntite(@PathVariable String codeEntite) {
        List<Site> sites = this.siteService.getSitesByCodeEntite(codeEntite);
        return ResponseEntity.ok(sites);
    }

    @GetMapping(value={"/description/{description}"})
    public ResponseEntity<Site> getSiteByDescription(@PathVariable String description) {
        return this.siteService.getSiteByDescription(description).map(ResponseEntity::ok).orElse(ResponseEntity.notFound().build());
    }
}

