/*
 * Decompiled with CFR 0.152.
 */
package com.smldb2.demo.controllers;

import com.smldb2.demo.DTO.ReportingAnnuelDTO;
import com.smldb2.demo.services.StatActAnnService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/statistiques-annuelles"})
@CrossOrigin(origins={"**"})
public class StatActAnnController {
    @Autowired
    private StatActAnnService statActAnnService;

    @GetMapping(value={"/annees"})
    public ResponseEntity<List<Integer>> getAnnees() {
        List<Integer> annees = this.statActAnnService.getAllAnnees();
        return ResponseEntity.ok(annees);
    }

    @GetMapping(value={"/societes"})
    public ResponseEntity<List<String>> getSocietes() {
        List<String> societes = this.statActAnnService.getAllSocietes();
        return ResponseEntity.ok(societes);
    }

    @GetMapping(value={"/reporting"})
    public ResponseEntity<ReportingAnnuelDTO> getReportingAnnuel(@RequestParam Integer annee, @RequestParam String codeSociete) {
        ReportingAnnuelDTO reporting = this.statActAnnService.getReportingAnnuel(annee, codeSociete);
        return ResponseEntity.ok((Object)reporting);
    }
}

