/*
 * Decompiled with CFR 0.152.
 */
package com.smldb2.demo.controllers;

import com.smldb2.demo.DTO.ActeDetailDTO;
import com.smldb2.demo.DTO.ReportingResponseDTO;
import com.smldb2.demo.services.StatActDateService;
import java.time.LocalDate;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/statistiques"})
@CrossOrigin(origins={"**"})
public class StatActDateController {
    @Autowired
    private StatActDateService statActDateService;

    @GetMapping(value={"/societes"})
    public ResponseEntity<List<String>> getSocietes() {
        List<String> societes = this.statActDateService.getAllSocietes();
        return ResponseEntity.ok(societes);
    }

    @GetMapping(value={"/reporting"})
    public ResponseEntity<ReportingResponseDTO> getReporting(@RequestParam String codeSociete, @RequestParam @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) LocalDate dateDebut, @RequestParam @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) LocalDate dateFin) {
        ReportingResponseDTO reporting = this.statActDateService.getReportingBySocieteAndPeriode(codeSociete, dateDebut, dateFin);
        return ResponseEntity.ok((Object)reporting);
    }

    @GetMapping(value={"/adherents"})
    public ResponseEntity<List<String>> getAdherents(@RequestParam String codeSociete, @RequestParam @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) LocalDate dateDebut, @RequestParam @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) LocalDate dateFin) {
        List<String> matricules = this.statActDateService.getMatriculesBySocieteAndPeriode(codeSociete, dateDebut, dateFin);
        return ResponseEntity.ok(matricules);
    }

    @GetMapping(value={"/adherents/{matricule}/actes"})
    public ResponseEntity<List<ActeDetailDTO>> getActesByAdherent(@PathVariable String matricule, @RequestParam String codeSociete, @RequestParam @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) LocalDate dateDebut, @RequestParam @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) LocalDate dateFin) {
        List<ActeDetailDTO> actes = this.statActDateService.getActesByMatricule(matricule, codeSociete, dateDebut, dateFin);
        return ResponseEntity.ok(actes);
    }
}

