/*
 * Decompiled with CFR 0.152.
 */
package com.smldb2.demo.controllers;

import com.smldb2.demo.Entity.Suggestion;
import com.smldb2.demo.services.SuggestionService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/suggestions"})
@CrossOrigin(origins={"**"})
public class SuggestionController {
    @Autowired
    private SuggestionService suggestionService;

    @GetMapping
    public ResponseEntity<List<Suggestion>> getAllSuggestions() {
        List<Suggestion> suggestions = this.suggestionService.getAllSuggestions();
        return ResponseEntity.ok(suggestions);
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<Suggestion> getSuggestionById(@PathVariable Integer id) {
        return this.suggestionService.getSuggestionById(id).map(ResponseEntity::ok).orElse(ResponseEntity.notFound().build());
    }

    @GetMapping(value={"/user/{persoId}"})
    public ResponseEntity<List<Suggestion>> getSuggestionsByPersoId(@PathVariable String persoId) {
        List<Suggestion> suggestions = this.suggestionService.getSuggestionsByPersoId(persoId);
        return ResponseEntity.ok(suggestions);
    }

    @GetMapping(value={"/exported/{exported}"})
    public ResponseEntity<List<Suggestion>> getSuggestionsByExported(@PathVariable String exported) {
        List<Suggestion> suggestions = this.suggestionService.getSuggestionsByExported(exported);
        return ResponseEntity.ok(suggestions);
    }
}

