/*
 * Decompiled with CFR 0.152.
 */
package com.smldb2.demo.controllers;

import com.smldb2.demo.Entity.Tel;
import com.smldb2.demo.services.TelService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/tels"})
@CrossOrigin(origins={"**"})
public class TelController {
    @Autowired
    private TelService telService;

    @GetMapping
    public ResponseEntity<List<Tel>> getAllTels() {
        List<Tel> tels = this.telService.getAllTels();
        return ResponseEntity.ok(tels);
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<Tel> getTelById(@PathVariable Integer id) {
        return this.telService.getTelById(id).map(ResponseEntity::ok).orElse(ResponseEntity.notFound().build());
    }

    @GetMapping(value={"/user/{persoId}"})
    public ResponseEntity<List<Tel>> getTelsByPersoId(@PathVariable String persoId) {
        List<Tel> tels = this.telService.getTelsByPersoId(persoId);
        return ResponseEntity.ok(tels);
    }

    @GetMapping(value={"/exported/{exported}"})
    public ResponseEntity<List<Tel>> getTelsByExported(@PathVariable String exported) {
        List<Tel> tels = this.telService.getTelsByExported(exported);
        return ResponseEntity.ok(tels);
    }
}

