/*
 * Decompiled with CFR 0.152.
 */
package com.smldb2.demo.controllers;

import com.smldb2.demo.DTO.UnifiedLoginResponse;
import com.smldb2.demo.DTO.UserDetailedStatsDTO;
import com.smldb2.demo.DTO.UserStatsDTO;
import com.smldb2.demo.Entity.Famille;
import com.smldb2.demo.Entity.TypePrestataire;
import com.smldb2.demo.Entity.User;
import com.smldb2.demo.repositories.FamilleRepository;
import com.smldb2.demo.services.AuthService;
import com.smldb2.demo.services.UserService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/users"})
@CrossOrigin(origins={"**"})
public class UserController {
    @Autowired
    private FamilleRepository familleRepository;
    @Autowired
    private UserService userService;
    @Autowired
    private AuthService authService;

    @PostMapping(value={"/login"})
    public ResponseEntity<UnifiedLoginResponse> login(@RequestBody User loginRequest) {
        UnifiedLoginResponse response = this.authService.login(loginRequest.getPersoId(), loginRequest.getPersoPassed());
        if (response.isSuccess()) {
            return ResponseEntity.ok((Object)response);
        }
        return ResponseEntity.status((int)401).body((Object)response);
    }

    @GetMapping
    public ResponseEntity<List<User>> getAllUsers() {
        List<User> users = this.userService.getAllUsers();
        return ResponseEntity.ok(users);
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<User> getUserById(@PathVariable String id) {
        return this.userService.getUserById(id).map(ResponseEntity::ok).orElse(ResponseEntity.notFound().build());
    }

    @GetMapping(value={"/name/{name}"})
    public ResponseEntity<User> getUserByName(@PathVariable String name) {
        return this.userService.getUserByName(name).map(ResponseEntity::ok).orElse(ResponseEntity.notFound().build());
    }

    @GetMapping(value={"/email/{email}"})
    public ResponseEntity<List<User>> getUsersByEmail(@PathVariable String email) {
        List<User> users = this.userService.getUsersByEmail(email);
        return ResponseEntity.ok(users);
    }

    @GetMapping(value={"/sexe/{sexe}"})
    public ResponseEntity<List<User>> getUsersBySexe(@PathVariable String sexe) {
        List<User> users = this.userService.getUsersBySexe(sexe);
        return ResponseEntity.ok(users);
    }

    @GetMapping(value={"/companies"})
    public ResponseEntity<List<String>> getAllCompanies() {
        try {
            List<String> companies = this.userService.getAllCompanyCodes();
            return ResponseEntity.ok(companies);
        }
        catch (Exception e) {
            System.err.println("\u274c Erreur dans getAllCompanies: " + e.getMessage());
            e.printStackTrace();
            return ResponseEntity.ok(List.of());
        }
    }

    @GetMapping(value={"/stats/global"})
    public ResponseEntity<UserStatsDTO> getGlobalStats() {
        try {
            UserStatsDTO stats = this.userService.getGlobalStats();
            return ResponseEntity.ok((Object)stats);
        }
        catch (Exception e) {
            System.err.println("\u274c Erreur dans getGlobalStats: " + e.getMessage());
            e.printStackTrace();
            return ResponseEntity.ok((Object)new UserStatsDTO(0L, 0L));
        }
    }

    @GetMapping(value={"/stats/detailed"})
    public ResponseEntity<UserDetailedStatsDTO> getDetailedStats() {
        try {
            UserDetailedStatsDTO stats = this.userService.getDetailedStats();
            return ResponseEntity.ok((Object)stats);
        }
        catch (Exception e) {
            System.err.println("\u274c Erreur dans getDetailedStats: " + e.getMessage());
            e.printStackTrace();
            UserDetailedStatsDTO emptyStats = new UserDetailedStatsDTO();
            emptyStats.setRepartitionParSexe(new HashMap<String, Long>());
            emptyStats.setRepartitionParSituationFamiliale(new HashMap<String, Long>());
            return ResponseEntity.ok((Object)emptyStats);
        }
    }

    @GetMapping(value={"/stats/evolution"})
    public ResponseEntity<Map<String, Long>> getEvolutionStats() {
        Map<String, Long> evolution = this.userService.getMonthlyEvolution();
        return ResponseEntity.ok(evolution);
    }

    @GetMapping(value={"/stats/global/company/{codeEntreprise}"})
    public ResponseEntity<UserStatsDTO> getGlobalStatsByCompany(@PathVariable String codeEntreprise) {
        try {
            UserStatsDTO stats = this.userService.getGlobalStatsByCompany(codeEntreprise);
            return ResponseEntity.ok((Object)stats);
        }
        catch (Exception e) {
            System.err.println("\u274c Erreur dans getGlobalStatsByCompany: " + e.getMessage());
            e.printStackTrace();
            return ResponseEntity.ok((Object)new UserStatsDTO(0L, 0L));
        }
    }

    @GetMapping(value={"/stats/detailed/company/{codeEntreprise}"})
    public ResponseEntity<UserDetailedStatsDTO> getDetailedStatsByCompany(@PathVariable String codeEntreprise) {
        try {
            UserDetailedStatsDTO stats = this.userService.getDetailedStatsByCompany(codeEntreprise);
            return ResponseEntity.ok((Object)stats);
        }
        catch (Exception e) {
            System.err.println("\u274c Erreur dans getDetailedStatsByCompany: " + e.getMessage());
            e.printStackTrace();
            UserDetailedStatsDTO emptyStats = new UserDetailedStatsDTO();
            emptyStats.setRepartitionParSexe(new HashMap<String, Long>());
            emptyStats.setRepartitionParSituationFamiliale(new HashMap<String, Long>());
            return ResponseEntity.ok((Object)emptyStats);
        }
    }

    @GetMapping(value={"/stats/evolution/company/{codeEntreprise}"})
    public ResponseEntity<Map<String, Long>> getEvolutionStatsByCompany(@PathVariable String codeEntreprise) {
        try {
            Map<String, Long> evolution = this.userService.getMonthlyEvolutionByCompany(codeEntreprise);
            return ResponseEntity.ok(evolution);
        }
        catch (Exception e) {
            System.err.println("\u274c Erreur dans getEvolutionStatsByCompany: " + e.getMessage());
            e.printStackTrace();
            return ResponseEntity.ok(new HashMap());
        }
    }

    @GetMapping(value={"/{persoId}/rib"})
    public ResponseEntity<Map<String, Object>> getRibByPersoId(@PathVariable String persoId) {
        try {
            Map<String, Object> response = this.userService.getRibByPersoId(persoId);
            return ResponseEntity.ok(response);
        }
        catch (Exception e) {
            HashMap<String, Object> errorResponse = new HashMap<String, Object>();
            errorResponse.put("success", false);
            errorResponse.put("message", e.getMessage());
            return ResponseEntity.status((int)500).body(errorResponse);
        }
    }

    @PutMapping(value={"/{persoId}/rib"})
    public ResponseEntity<Map<String, Object>> updateRib(@PathVariable String persoId, @RequestBody Map<String, String> request) {
        String newRib = request.get("rib");
        if (newRib == null || newRib.trim().isEmpty()) {
            HashMap<String, Object> errorResponse = new HashMap<String, Object>();
            errorResponse.put("success", false);
            errorResponse.put("message", "Le RIB ne peut pas \u00eatre vide");
            return ResponseEntity.badRequest().body(errorResponse);
        }
        String cleanRib = newRib.replaceAll("\\s+", "");
        if (!cleanRib.matches("\\d{20}")) {
            HashMap<String, Object> errorResponse = new HashMap<String, Object>();
            errorResponse.put("success", false);
            errorResponse.put("message", "Le RIB doit contenir exactement 20 chiffres");
            return ResponseEntity.badRequest().body(errorResponse);
        }
        Map<String, Object> response = this.userService.updateRib(persoId, cleanRib);
        if (((Boolean)response.getOrDefault("success", false)).booleanValue()) {
            return ResponseEntity.ok(response);
        }
        return ResponseEntity.status((int)400).body(response);
    }

    @GetMapping(value={"/{persoId}/contact"})
    public ResponseEntity<Map<String, String>> getContactByPersoId(@PathVariable String persoId) {
        String contact = this.userService.getContactByPersoId(persoId);
        if (contact != null) {
            HashMap<String, String> response = new HashMap<String, String>();
            response.put("persoId", persoId);
            response.put("contact", contact);
            return ResponseEntity.ok(response);
        }
        return ResponseEntity.notFound().build();
    }

    @PutMapping(value={"/{persoId}/contact"})
    public ResponseEntity<Map<String, Object>> updateContact(@PathVariable String persoId, @RequestBody Map<String, String> request) {
        String newContact = request.get("contact");
        if (newContact == null || newContact.trim().isEmpty()) {
            HashMap<String, Object> errorResponse = new HashMap<String, Object>();
            errorResponse.put("success", false);
            errorResponse.put("message", "Le contact ne peut pas \u00eatre vide");
            return ResponseEntity.badRequest().body(errorResponse);
        }
        String cleanContact = newContact.replaceAll("\\s+", "");
        if (!cleanContact.matches("^\\+?\\d{8,15}$")) {
            HashMap<String, Object> errorResponse = new HashMap<String, Object>();
            errorResponse.put("success", false);
            errorResponse.put("message", "Format de num\u00e9ro de t\u00e9l\u00e9phone invalide");
            return ResponseEntity.badRequest().body(errorResponse);
        }
        boolean success = this.userService.updateContact(persoId, newContact);
        HashMap<String, Object> response = new HashMap<String, Object>();
        if (success) {
            response.put("success", true);
            response.put("message", "Contact mis \u00e0 jour avec succ\u00e8s");
            response.put("persoId", persoId);
            response.put("contact", newContact);
            return ResponseEntity.ok(response);
        }
        response.put("success", false);
        response.put("message", "Impossible de mettre \u00e0 jour le contact");
        return ResponseEntity.status((int)500).body(response);
    }

    @GetMapping(value={"/stats/test"})
    public ResponseEntity<Map<String, Object>> testEndpoint() {
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("status", "OK");
        response.put("message", "User stats controller is working");
        response.put("timestamp", System.currentTimeMillis());
        return ResponseEntity.ok(response);
    }

    @GetMapping(value={"/stats/prestataires/total"})
    public ResponseEntity<Long> getTotalPrestataires() {
        try {
            long total = this.familleRepository.count();
            return ResponseEntity.ok((Object)total);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)0L);
        }
    }

    @GetMapping(value={"/stats/prestataires/total/company/{codeEntreprise}"})
    public ResponseEntity<Long> getTotalPrestatairesByCompany(@PathVariable String codeEntreprise) {
        try {
            List<User> users = this.userService.getUsersByCompany(codeEntreprise);
            List<String> persoIds = users.stream().map(User::getPersoId).collect(Collectors.toList());
            long total = this.familleRepository.countByPersoIdIn(persoIds);
            return ResponseEntity.ok((Object)total);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)0L);
        }
    }

    @GetMapping(value={"/stats/prestataires/detailed"})
    public ResponseEntity<Map<String, Object>> getDetailedPrestataireStats() {
        try {
            List allPrestataires = this.familleRepository.findAll();
            long conjoints = allPrestataires.stream().filter(f -> TypePrestataire.CONJOINT.equals((Object)f.getTypPrestataire())).count();
            long enfants = allPrestataires.stream().filter(f -> TypePrestataire.ENFANT.equals((Object)f.getTypPrestataire())).count();
            HashMap<String, Number> result = new HashMap<String, Number>();
            result.put("total", allPrestataires.size());
            result.put("conjoints", conjoints);
            result.put("enfants", enfants);
            return ResponseEntity.ok(result);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body(new HashMap());
        }
    }

    @GetMapping(value={"/stats/prestataires/detailed/company/{codeEntreprise}"})
    public ResponseEntity<Map<String, Object>> getDetailedPrestataireStatsByCompany(@PathVariable String codeEntreprise) {
        try {
            List<User> users = this.userService.getUsersByCompany(codeEntreprise);
            List<String> persoIds = users.stream().map(User::getPersoId).collect(Collectors.toList());
            List<Famille> prestataires = this.familleRepository.findByPersoIdIn(persoIds);
            long conjoints = prestataires.stream().filter(f -> TypePrestataire.CONJOINT.equals((Object)f.getTypPrestataire())).count();
            long enfants = prestataires.stream().filter(f -> TypePrestataire.ENFANT.equals((Object)f.getTypPrestataire())).count();
            HashMap<String, Number> result = new HashMap<String, Number>();
            result.put("total", prestataires.size());
            result.put("conjoints", conjoints);
            result.put("enfants", enfants);
            return ResponseEntity.ok(result);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body(new HashMap());
        }
    }

    @PostMapping(value={"/rib/process-pending"})
    public ResponseEntity<Map<String, Object>> processPendingRibs() {
        try {
            this.userService.traiterDemandesRibEnAttente();
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Demandes RIB trait\u00e9es avec succ\u00e8s");
            return ResponseEntity.ok(response);
        }
        catch (Exception e) {
            HashMap<String, Object> errorResponse = new HashMap<String, Object>();
            errorResponse.put("success", false);
            errorResponse.put("message", "Erreur lors du traitement : " + e.getMessage());
            return ResponseEntity.status((int)500).body(errorResponse);
        }
    }

    @GetMapping(value={"/{persoId}/contact/v2"})
    public ResponseEntity<Map<String, Object>> getContactByPersoIdV2(@PathVariable String persoId) {
        try {
            Map<String, Object> response = this.userService.getContactByPersoIdV2(persoId);
            return ResponseEntity.ok(response);
        }
        catch (Exception e) {
            HashMap<String, Object> errorResponse = new HashMap<String, Object>();
            errorResponse.put("success", false);
            errorResponse.put("message", e.getMessage());
            return ResponseEntity.status((int)500).body(errorResponse);
        }
    }

    @PutMapping(value={"/{persoId}/contact/v2"})
    public ResponseEntity<Map<String, Object>> updateContactV2(@PathVariable String persoId, @RequestBody Map<String, String> request) {
        String newContact = request.get("contact");
        if (newContact == null || newContact.trim().isEmpty()) {
            HashMap<String, Object> errorResponse = new HashMap<String, Object>();
            errorResponse.put("success", false);
            errorResponse.put("message", "Le contact ne peut pas \u00eatre vide");
            return ResponseEntity.badRequest().body(errorResponse);
        }
        String cleanContact = newContact.replaceAll("\\s+", "");
        if (!cleanContact.matches("^\\+?\\d{8,15}$")) {
            HashMap<String, Object> errorResponse = new HashMap<String, Object>();
            errorResponse.put("success", false);
            errorResponse.put("message", "Format de num\u00e9ro de t\u00e9l\u00e9phone invalide");
            return ResponseEntity.badRequest().body(errorResponse);
        }
        Map<String, Object> response = this.userService.updateContactV2(persoId, newContact);
        if (((Boolean)response.getOrDefault("success", false)).booleanValue()) {
            return ResponseEntity.ok(response);
        }
        return ResponseEntity.status((int)400).body(response);
    }

    @PostMapping(value={"/contact/process-pending"})
    public ResponseEntity<Map<String, Object>> processPendingContacts() {
        try {
            this.userService.traiterDemandesTelEnAttente();
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Demandes de t\u00e9l\u00e9phone trait\u00e9es avec succ\u00e8s");
            return ResponseEntity.ok(response);
        }
        catch (Exception e) {
            HashMap<String, Object> errorResponse = new HashMap<String, Object>();
            errorResponse.put("success", false);
            errorResponse.put("message", "Erreur lors du traitement : " + e.getMessage());
            return ResponseEntity.status((int)500).body(errorResponse);
        }
    }
}

