/*
 * Decompiled with CFR 0.152.
 */
package com.smldb2.demo.controllers;

import com.smldb2.demo.Entity.UsersAdmin;
import com.smldb2.demo.services.UsersAdminService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/admins"})
@CrossOrigin(origins={"**"})
public class UsersAdminController {
    @Autowired
    private UsersAdminService usersAdminService;

    @GetMapping
    public ResponseEntity<List<UsersAdmin>> getAllUsersAdmin() {
        List<UsersAdmin> admins = this.usersAdminService.getAllUsersAdmin();
        return ResponseEntity.ok(admins);
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<UsersAdmin> getUserAdminById(@PathVariable String id) {
        return this.usersAdminService.getUserAdminById(id).map(ResponseEntity::ok).orElse(ResponseEntity.notFound().build());
    }

    @GetMapping(value={"/name/{name}"})
    public ResponseEntity<UsersAdmin> getUserAdminByName(@PathVariable String name) {
        return this.usersAdminService.getUserAdminByName(name).map(ResponseEntity::ok).orElse(ResponseEntity.notFound().build());
    }
}

