/*
 * Decompiled with CFR 0.152.
 */
package com.smldb2.demo.controllers;

import com.smldb2.demo.Entity.UsersSociete;
import com.smldb2.demo.services.UsersSocieteService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/societes"})
@CrossOrigin(origins={"**"})
public class UsersSocieteController {
    @Autowired
    private UsersSocieteService usersSocieteService;

    @GetMapping
    public ResponseEntity<List<UsersSociete>> getAllUsersSociete() {
        List<UsersSociete> societes = this.usersSocieteService.getAllUsersSociete();
        return ResponseEntity.ok(societes);
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<UsersSociete> getUserSocieteById(@PathVariable String id) {
        return this.usersSocieteService.getUserSocieteById(id).map(ResponseEntity::ok).orElse(ResponseEntity.notFound().build());
    }

    @GetMapping(value={"/name/{name}"})
    public ResponseEntity<UsersSociete> getUserSocieteByName(@PathVariable String name) {
        return this.usersSocieteService.getUserSocieteByName(name).map(ResponseEntity::ok).orElse(ResponseEntity.notFound().build());
    }
}

