/*
 * Decompiled with CFR 0.152.
 */
package com.smldb2.demo.repositories;

import com.smldb2.demo.Entity.ActeDate;
import java.util.Date;
import java.util.List;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface ActeDateRepository
extends JpaRepository<ActeDate, Long> {
    @Query(value="SELECT a.matricule, COUNT(DISTINCT a.dateBs) as nombreBs, SUM(a.depense) as totalDepense, SUM(a.rembourse) as totalRembourse FROM ActeDate a WHERE a.codeSociete = :codeSociete AND a.dateBs BETWEEN :dateDebut AND :dateFin GROUP BY a.matricule")
    public List<Object[]> getStatistiquesAdherents(@Param(value="codeSociete") String var1, @Param(value="dateDebut") Date var2, @Param(value="dateFin") Date var3);

    @Query(value="SELECT a FROM ActeDate a WHERE a.matricule = :matricule AND a.codeSociete = :codeSociete AND a.dateBs BETWEEN :dateDebut AND :dateFin ORDER BY a.dateBs DESC")
    public List<ActeDate> getActesByAdherent(@Param(value="matricule") String var1, @Param(value="codeSociete") String var2, @Param(value="dateDebut") Date var3, @Param(value="dateFin") Date var4);

    @Query(value="SELECT a.acte, SUM(a.depense) as totalDepense, SUM(a.rembourse) as totalRembourse, COUNT(a) as nombre FROM ActeDate a WHERE a.matricule = :matricule AND a.codeSociete = :codeSociete AND a.dateBs BETWEEN :dateDebut AND :dateFin GROUP BY a.acte")
    public List<Object[]> getStatistiquesActesByAdherent(@Param(value="matricule") String var1, @Param(value="codeSociete") String var2, @Param(value="dateDebut") Date var3, @Param(value="dateFin") Date var4);
}

