/*
 * Decompiled with CFR 0.152.
 */
package com.smldb2.demo.repositories;

import com.smldb2.demo.Entity.Bordereau;
import java.util.List;
import java.util.Optional;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface BordereauRepository
extends JpaRepository<Bordereau, String> {
    public Optional<Bordereau> findByRefBordereau(String var1);

    public List<Bordereau> findByRefBordereauContaining(String var1);

    @Query(value="SELECT COUNT(b) FROM Bordereau b WHERE b.refBordereau LIKE CONCAT(:prefix, '%')")
    public long countByPrefix(@Param(value="prefix") String var1);

    @Query(value="SELECT DISTINCT b FROM Bordereau b LEFT JOIN FETCH b.remboursements WHERE SIZE(b.remboursements) > 0")
    public List<Bordereau> findBordereauxWithRemboursements();

    @Query(value="SELECT COUNT(r) FROM Bordereau b JOIN b.remboursements r WHERE b.refBordereau = :refBordereau")
    public long countRemboursementsByBordereau(@Param(value="refBordereau") String var1);

    @Query(value="SELECT COALESCE(SUM(r.mntBs), 0) FROM Bordereau b JOIN b.remboursements r WHERE b.refBordereau = :refBordereau")
    public Double sumMontantDepenseByBordereau(@Param(value="refBordereau") String var1);

    @Query(value="SELECT COALESCE(SUM(r.mntBsRemb), 0) FROM Bordereau b JOIN b.remboursements r WHERE b.refBordereau = :refBordereau")
    public Double sumMontantRembourseeByBordereau(@Param(value="refBordereau") String var1);

    public List<Bordereau> findByRefBordereauStartingWith(String var1);

    @Query(value="SELECT b FROM Bordereau b JOIN b.remboursements r WHERE r.codeEntreprise = :code")
    public List<Bordereau> findByCodeEntreprise(@Param(value="code") String var1);

    @Query(value="SELECT DISTINCT b FROM Bordereau b JOIN b.remboursements r WHERE r.site = :site")
    public List<Bordereau> findBySite(@Param(value="site") String var1);
}

