/*
 * Decompiled with CFR 0.152.
 */
package com.smldb2.demo.repositories;

import com.smldb2.demo.Entity.StatActAnn;
import java.util.List;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface StatActAnnRepository
extends JpaRepository<StatActAnn, Long> {
    @Query(value="SELECT DISTINCT s.annee FROM StatActAnn s ORDER BY s.annee DESC")
    public List<Integer> findAllDistinctAnnees();

    @Query(value="SELECT DISTINCT s.codeSociete FROM StatActAnn s ORDER BY s.codeSociete")
    public List<String> findAllDistinctSocietes();

    @Query(value="SELECT s.acte, SUM(s.depense), SUM(s.rembourser) FROM StatActAnn s WHERE s.annee = :annee AND s.codeSociete = :codeSociete GROUP BY s.acte ORDER BY SUM(s.depense) DESC")
    public List<Object[]> findStatistiquesActesByAnneeAndSociete(@Param(value="annee") Integer var1, @Param(value="codeSociete") String var2);

    @Query(value="SELECT SUM(s.depense), SUM(s.rembourser), COUNT(DISTINCT s.acte) FROM StatActAnn s WHERE s.annee = :annee AND s.codeSociete = :codeSociete")
    public List<Object[]> findStatistiquesGlobales(@Param(value="annee") Integer var1, @Param(value="codeSociete") String var2);

    @Query(value="SELECT s FROM StatActAnn s WHERE s.annee = :annee AND s.codeSociete = :codeSociete ORDER BY s.acte")
    public List<StatActAnn> findByAnneeAndSociete(@Param(value="annee") Integer var1, @Param(value="codeSociete") String var2);
}

