/*
 * Decompiled with CFR 0.152.
 */
package com.smldb2.demo.repositories;

import com.smldb2.demo.Entity.StatActDate;
import java.time.LocalDate;
import java.util.List;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface StatActDateRepository
extends JpaRepository<StatActDate, Long> {
    @Query(value="SELECT DISTINCT s.codeSociete FROM StatActDate s ORDER BY s.codeSociete")
    public List<String> findAllDistinctCodeSociete();

    @Query(value="SELECT DISTINCT s.matricule FROM StatActDate s WHERE s.dateBs BETWEEN :dateDebut AND :dateFin AND s.codeSociete = :codeSociete ORDER BY s.matricule")
    public List<String> findMatriculesBySocieteAndPeriode(@Param(value="codeSociete") String var1, @Param(value="dateDebut") LocalDate var2, @Param(value="dateFin") LocalDate var3);

    @Query(value="SELECT s FROM StatActDate s WHERE s.matricule = :matricule AND s.codeSociete = :codeSociete AND s.dateBs BETWEEN :dateDebut AND :dateFin ORDER BY s.dateBs DESC, s.acte")
    public List<StatActDate> findActesByMatriculeAndPeriode(@Param(value="matricule") String var1, @Param(value="codeSociete") String var2, @Param(value="dateDebut") LocalDate var3, @Param(value="dateFin") LocalDate var4);

    @Query(value="SELECT s.acte as acte, SUM(s.depense) as totalDepense, SUM(s.rembourse) as totalRembourse, COUNT(s) as nombreActes FROM StatActDate s WHERE s.codeSociete = :codeSociete AND s.dateBs BETWEEN :dateDebut AND :dateFin GROUP BY s.acte ORDER BY SUM(s.depense) DESC")
    public List<Object[]> findStatistiquesActesBySocieteAndPeriode(@Param(value="codeSociete") String var1, @Param(value="dateDebut") LocalDate var2, @Param(value="dateFin") LocalDate var3);

    @Query(value="SELECT s.matricule as matricule, SUM(s.depense) as totalDepense, SUM(s.rembourse) as totalRembourse, COUNT(s) as nombreActes FROM StatActDate s WHERE s.codeSociete = :codeSociete AND s.dateBs BETWEEN :dateDebut AND :dateFin GROUP BY s.matricule ORDER BY SUM(s.depense) DESC")
    public List<Object[]> findStatistiquesParAdherent(@Param(value="codeSociete") String var1, @Param(value="dateDebut") LocalDate var2, @Param(value="dateFin") LocalDate var3);
}

