/*
 * Decompiled with CFR 0.152.
 */
package com.smldb2.demo.repositories;

import com.smldb2.demo.Entity.User;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface UserRepository
extends JpaRepository<User, String> {
    public Optional<User> findByPersoName(String var1);

    public List<User> findByEmailContaining(String var1);

    public List<User> findBySexe(String var1);

    public Optional<User> findByPersoIdAndPersoPassed(String var1, String var2);

    public Optional<User> findByEmail(String var1);

    public Optional<User> findByCin(String var1);

    public long countByDateCreationAfter(Date var1);

    @Query(value="SELECT u FROM User u WHERE SUBSTRING(u.persoId, 1, 8) = :codeEntreprise")
    public List<User> findByCodeEntreprise(@Param(value="codeEntreprise") String var1);

    @Query(value="SELECT COUNT(u) FROM User u WHERE SUBSTRING(u.persoId, 1, 8) = :codeEntreprise")
    public long countByCodeEntreprise(@Param(value="codeEntreprise") String var1);

    @Query(value="SELECT COUNT(u) FROM User u WHERE SUBSTRING(u.persoId, 1, 8) = :codeEntreprise AND u.dateCreation > :startDate")
    public long countByCodeEntrepriseAndDateCreationAfter(@Param(value="codeEntreprise") String var1, @Param(value="startDate") Date var2);

    @Query(value="SELECT DISTINCT SUBSTRING(u.persoId, 1, 8) FROM User u ORDER BY SUBSTRING(u.persoId, 1, 8)")
    public List<String> findAllDistinctCompanyCodes();

    @Query(value="SELECT u.rib FROM User u WHERE u.persoId = :persoId")
    public String findRibByPersoId(@Param(value="persoId") String var1);

    @Query(value="SELECT u.contact FROM User u WHERE u.persoId = :persoId")
    public String findContactByPersoId(@Param(value="persoId") String var1);

    public Optional<User> findByPersoId(String var1);

    public boolean existsByPersoId(String var1);

    public boolean existsByEmail(String var1);

    @Query(value="SELECT COUNT(f) FROM Famille f WHERE f.persoId = :persoId")
    public Long countFamilleByPersoId(@Param(value="persoId") String var1);
}

