/*
 * Decompiled with CFR 0.152.
 */
package com.smldb2.demo.services;

import com.smldb2.demo.Entity.Acte;
import com.smldb2.demo.Entity.Remboursement;
import com.smldb2.demo.repositories.ActeRepository;
import com.smldb2.demo.repositories.RemboursementRepository;
import jakarta.transaction.Transactional;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ActeAffectationService {
    @Autowired
    private ActeRepository acteRepository;
    @Autowired
    private RemboursementRepository remboursementRepository;

    @Transactional
    public Map<String, Object> affecterTousLesActes() {
        List tousLesActes = this.acteRepository.findAll();
        int actesAffectes = 0;
        int actesNonAffectes = 0;
        for (Acte acte : tousLesActes) {
            if (acte.getRefBsPhys() != null) {
                Optional remboursementOpt = this.remboursementRepository.findById(acte.getRefBsPhys());
                if (remboursementOpt.isPresent()) {
                    Remboursement remboursement = (Remboursement)remboursementOpt.get();
                    acte.setRemboursement(remboursement);
                    this.acteRepository.save(acte);
                    ++actesAffectes;
                    continue;
                }
                ++actesNonAffectes;
                continue;
            }
            ++actesNonAffectes;
        }
        HashMap<String, Object> resultat = new HashMap<String, Object>();
        resultat.put("total_actes", tousLesActes.size());
        resultat.put("actes_affectes", actesAffectes);
        resultat.put("actes_non_affectes", actesNonAffectes);
        resultat.put("message", "Affectation termin\u00e9e avec succ\u00e8s");
        return resultat;
    }

    @Transactional
    public Map<String, Object> affecterActesPourRemboursement(String refBsPhys) {
        Optional remboursementOpt = this.remboursementRepository.findById(refBsPhys);
        if (!remboursementOpt.isPresent()) {
            HashMap<String, Object> erreur = new HashMap<String, Object>();
            erreur.put("erreur", "Remboursement non trouv\u00e9 avec REF_BS_PHYS: " + refBsPhys);
            return erreur;
        }
        Remboursement remboursement = (Remboursement)remboursementOpt.get();
        List<Acte> actes = this.acteRepository.findByRefBsPhys(refBsPhys);
        for (Acte acte : actes) {
            acte.setRemboursement(remboursement);
            this.acteRepository.save(acte);
        }
        HashMap<String, Object> resultat = new HashMap<String, Object>();
        resultat.put("ref_bs_phys", refBsPhys);
        resultat.put("nombre_actes_affectes", actes.size());
        resultat.put("message", "Actes affect\u00e9s au remboursement avec succ\u00e8s");
        return resultat;
    }

    @Transactional
    public Map<String, Object> affecterActeUnique(Long idActe, String refBsPhys) {
        Optional acteOpt = this.acteRepository.findById(idActe);
        Optional remboursementOpt = this.remboursementRepository.findById(refBsPhys);
        HashMap<String, Object> resultat = new HashMap<String, Object>();
        if (!acteOpt.isPresent()) {
            resultat.put("erreur", "Acte non trouv\u00e9 avec ID: " + idActe);
            return resultat;
        }
        if (!remboursementOpt.isPresent()) {
            resultat.put("erreur", "Remboursement non trouv\u00e9 avec REF_BS_PHYS: " + refBsPhys);
            return resultat;
        }
        Acte acte = (Acte)acteOpt.get();
        Remboursement remboursement = (Remboursement)remboursementOpt.get();
        acte.setRemboursement(remboursement);
        acte.setRefBsPhys(refBsPhys);
        this.acteRepository.save(acte);
        resultat.put("id_acte", idActe);
        resultat.put("ref_bs_phys", refBsPhys);
        resultat.put("message", "Acte affect\u00e9 avec succ\u00e8s");
        return resultat;
    }

    public Map<String, Object> verifierEtatAffectation() {
        List tousLesActes = this.acteRepository.findAll();
        long actesAffectes = tousLesActes.stream().filter(acte -> acte.getRemboursement() != null).count();
        long actesNonAffectes = (long)tousLesActes.size() - actesAffectes;
        HashMap<String, Object> etat = new HashMap<String, Object>();
        etat.put("total_actes", tousLesActes.size());
        etat.put("actes_affectes", actesAffectes);
        etat.put("actes_non_affectes", actesNonAffectes);
        etat.put("pourcentage_affectation", tousLesActes.size() > 0 ? (double)actesAffectes * 100.0 / (double)tousLesActes.size() : 0.0);
        return etat;
    }

    @Transactional
    public Map<String, Object> desaffecterActe(Long idActe) {
        Optional acteOpt = this.acteRepository.findById(idActe);
        HashMap<String, Object> resultat = new HashMap<String, Object>();
        if (!acteOpt.isPresent()) {
            resultat.put("erreur", "Acte non trouv\u00e9 avec ID: " + idActe);
            return resultat;
        }
        Acte acte = (Acte)acteOpt.get();
        acte.setRemboursement(null);
        this.acteRepository.save(acte);
        resultat.put("id_acte", idActe);
        resultat.put("message", "Acte d\u00e9saffect\u00e9 avec succ\u00e8s");
        return resultat;
    }
}

