/*
 * Decompiled with CFR 0.152.
 */
package com.smldb2.demo.services;

import com.smldb2.demo.DTO.BordereauStatsDTO;
import com.smldb2.demo.DTO.BordereauSummaryDTO;
import com.smldb2.demo.DTO.GlobalStatsDTO;
import com.smldb2.demo.DTO.TopAdherentDTO;
import com.smldb2.demo.Entity.Bordereau;
import com.smldb2.demo.Entity.Famille;
import com.smldb2.demo.Entity.Remboursement;
import com.smldb2.demo.Entity.TypePrestataire;
import com.smldb2.demo.repositories.BordereauRepository;
import com.smldb2.demo.repositories.FamilleRepository;
import com.smldb2.demo.repositories.RemboursementRepository;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.Period;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class BordereauService {
    private final BordereauRepository bordereauRepository;
    private final RemboursementRepository remboursementRepository;
    private final FamilleRepository familleRepository;

    public BordereauService(BordereauRepository bordereauRepository, RemboursementRepository remboursementRepository, FamilleRepository familleRepository) {
        this.bordereauRepository = bordereauRepository;
        this.remboursementRepository = remboursementRepository;
        this.familleRepository = familleRepository;
    }

    public List<Bordereau> getAllBordereaux() {
        return this.bordereauRepository.findAll();
    }

    public List<Bordereau> getBordereauxByPrefix(String prefix) {
        return this.bordereauRepository.findByRefBordereauStartingWith(prefix);
    }

    public Optional<Bordereau> getBordereauAvecRemboursements(String refBordereau) {
        return this.bordereauRepository.findById(refBordereau);
    }

    public GlobalStatsDTO getGlobalBordereauxStats(String prefix) {
        List<Bordereau> bordereaux = prefix != null && !prefix.isEmpty() ? this.getBordereauxByPrefix(prefix) : this.getAllBordereaux();
        List<BordereauSummaryDTO> summaries = bordereaux.stream().map(this::createBordereauSummary).collect(Collectors.toList());
        BigDecimal totalDepense = summaries.stream().map(BordereauSummaryDTO::getMontantDepense).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totalRembourse = summaries.stream().map(BordereauSummaryDTO::getMontantRembourse).reduce(BigDecimal.ZERO, BigDecimal::add);
        return new GlobalStatsDTO(bordereaux.size(), totalDepense, totalRembourse, summaries);
    }

    private BordereauSummaryDTO createBordereauSummary(Bordereau bordereau) {
        List<Remboursement> rembs = bordereau.getRemboursements();
        BigDecimal depense = rembs.stream().map(r -> r.getMntBs() != null ? r.getMntBs() : BigDecimal.ZERO).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal rembourse = rembs.stream().map(r -> r.getMntBsRemb() != null ? r.getMntBsRemb() : BigDecimal.ZERO).reduce(BigDecimal.ZERO, BigDecimal::add);
        double taux = depense.compareTo(BigDecimal.ZERO) > 0 ? rembourse.divide(depense, 4, RoundingMode.HALF_UP).multiply(BigDecimal.valueOf(100L)).doubleValue() : 0.0;
        return new BordereauSummaryDTO(bordereau.getRefBordereau(), bordereau.getDateBordereau(), rembs.size(), depense, rembourse, taux);
    }

    public BordereauStatsDTO getBordereauStats(String refBordereau) {
        Bordereau bordereau = (Bordereau)this.bordereauRepository.findById(refBordereau).orElseThrow(() -> new RuntimeException("Bordereau non trouv\u00e9"));
        List<Remboursement> remboursements = bordereau.getRemboursements();
        List familles = this.familleRepository.findAll();
        return this.calculateBordereauStats(bordereau, remboursements, familles);
    }

    private BordereauStatsDTO calculateBordereauStats(Bordereau bordereau, List<Remboursement> remboursements, List<Famille> familles) {
        BordereauStatsDTO stats = new BordereauStatsDTO();
        stats.setRefBordereau(bordereau.getRefBordereau());
        stats.setDateBordereau(bordereau.getDateBordereau());
        stats.setTotalRemboursements(remboursements.size());
        Map<String, List<Famille>> familleMap = familles.stream().collect(Collectors.groupingBy(Famille::getPersoId));
        BigDecimal totalDepense = BigDecimal.ZERO;
        BigDecimal totalRembourse = BigDecimal.ZERO;
        ArrayList<BigDecimal> montantsRemb = new ArrayList<BigDecimal>();
        int adherents = 0;
        int conjoints = 0;
        int enfants = 0;
        int parents = 0;
        HashMap<String, BigDecimal> montantsParType = new HashMap<String, BigDecimal>();
        montantsParType.put("Adh\u00e9rent", BigDecimal.ZERO);
        montantsParType.put("Conjoint", BigDecimal.ZERO);
        montantsParType.put("Enfant", BigDecimal.ZERO);
        montantsParType.put("Parent", BigDecimal.ZERO);
        HashMap<String, Integer> repartitionStatut = new HashMap<String, Integer>();
        HashMap<String, Integer> repartitionSexe = new HashMap<String, Integer>();
        HashMap<String, Integer> repartitionAge = new HashMap<String, Integer>();
        repartitionAge.put("0-17", 0);
        repartitionAge.put("18-35", 0);
        repartitionAge.put("36-50", 0);
        repartitionAge.put("51-65", 0);
        repartitionAge.put("66+", 0);
        ArrayList<Integer> ages = new ArrayList<Integer>();
        HashMap<String, TopAdherentData> adherentData = new HashMap<String, TopAdherentData>();
        for (Remboursement r : remboursements) {
            BigDecimal depense = r.getMntBs() != null ? r.getMntBs() : BigDecimal.ZERO;
            BigDecimal rembourse = r.getMntBsRemb() != null ? r.getMntBsRemb() : BigDecimal.ZERO;
            totalDepense = totalDepense.add(depense);
            totalRembourse = totalRembourse.add(rembourse);
            if (rembourse.compareTo(BigDecimal.ZERO) > 0) {
                montantsRemb.add(rembourse);
            }
            String statut = r.getStatBs() != null ? r.getStatBs() : "Non d\u00e9fini";
            repartitionStatut.merge(statut, 1, Integer::sum);
            String nomPrest = r.getNomPrenPrest() != null ? r.getNomPrenPrest().toLowerCase() : "";
            List famillesUser = familleMap.getOrDefault(r.getPersoId(), new ArrayList());
            Famille famille = famillesUser.stream().filter(f -> f.getPrenomPrestataire().toLowerCase().equals(nomPrest)).findFirst().orElse(null);
            String typeBenef = "Adh\u00e9rent";
            if (famille != null) {
                TypePrestataire type = famille.getTypPrestataire();
                if (type == TypePrestataire.CONJOINT) {
                    ++conjoints;
                    typeBenef = "Conjoint";
                } else if (type == TypePrestataire.ENFANT) {
                    ++enfants;
                    typeBenef = "Enfant";
                } else if (type == TypePrestataire.PERE || type == TypePrestataire.MERE) {
                    ++parents;
                    typeBenef = "Parent";
                } else {
                    ++adherents;
                }
                String sexe = famille.getSexe() != null ? famille.getSexe() : "Non d\u00e9fini";
                repartitionSexe.merge(sexe, 1, Integer::sum);
                if (famille.getDatNais() != null) {
                    LocalDate naissance = famille.getDatNais().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                    int age = Period.between(naissance, LocalDate.now()).getYears();
                    ages.add(age);
                    String tranche = this.getTrancheAge(age);
                    repartitionAge.merge(tranche, 1, Integer::sum);
                }
            } else {
                ++adherents;
            }
            montantsParType.merge(typeBenef, rembourse, BigDecimal::add);
            String nomComplet = r.getNomPrenPrest() != null ? r.getNomPrenPrest() : "Inconnu";
            adherentData.computeIfAbsent(nomComplet, k -> new TopAdherentData()).add(rembourse);
        }
        stats.setMontantTotalDepense(totalDepense);
        stats.setMontantTotalRembourse(totalRembourse);
        double tauxMoyen = totalDepense.compareTo(BigDecimal.ZERO) > 0 ? totalRembourse.divide(totalDepense, 4, RoundingMode.HALF_UP).multiply(BigDecimal.valueOf(100L)).doubleValue() : 0.0;
        stats.setTauxRemboursementMoyen(tauxMoyen);
        stats.setNombreAdherents(adherents);
        stats.setNombreConjoints(conjoints);
        stats.setNombreEnfants(enfants);
        stats.setNombreParents(parents);
        if (!montantsRemb.isEmpty()) {
            BigDecimal somme = montantsRemb.stream().reduce(BigDecimal.ZERO, BigDecimal::add);
            stats.setMontantMoyenRemboursement(somme.divide(BigDecimal.valueOf(montantsRemb.size()), 2, RoundingMode.HALF_UP));
            stats.setMontantMaxRemboursement(montantsRemb.stream().max(BigDecimal::compareTo).orElse(BigDecimal.ZERO));
            stats.setMontantMinRemboursement(montantsRemb.stream().min(BigDecimal::compareTo).orElse(BigDecimal.ZERO));
        }
        stats.setRepartitionMontantsParType(montantsParType);
        stats.setRepartitionParStatut(repartitionStatut);
        stats.setRepartitionParSexe(repartitionSexe);
        stats.setRepartitionParTrancheAge(repartitionAge);
        if (!ages.isEmpty()) {
            int moyenneAge = (int)ages.stream().mapToInt(Integer::intValue).average().orElse(0.0);
            stats.setMoyenneAge(moyenneAge);
        }
        List<TopAdherentDTO> topAdherents = adherentData.entrySet().stream().map(e -> new TopAdherentDTO((String)e.getKey(), ((TopAdherentData)e.getValue()).count, ((TopAdherentData)e.getValue()).montant)).sorted((a, b) -> b.getMontantTotal().compareTo(a.getMontantTotal())).limit(5L).collect(Collectors.toList());
        stats.setTopAdherents(topAdherents);
        return stats;
    }

    private String getTrancheAge(int age) {
        if (age <= 17) {
            return "0-17";
        }
        if (age <= 35) {
            return "18-35";
        }
        if (age <= 50) {
            return "36-50";
        }
        if (age <= 65) {
            return "51-65";
        }
        return "66+";
    }

    private static class TopAdherentData {
        int count = 0;
        BigDecimal montant = BigDecimal.ZERO;

        private TopAdherentData() {
        }

        void add(BigDecimal m) {
            ++this.count;
            this.montant = this.montant.add(m);
        }
    }
}

