/*
 * Decompiled with CFR 0.152.
 */
package com.smldb2.demo.services;

import com.opencsv.CSVReader;
import com.smldb2.demo.Entity.Client;
import com.smldb2.demo.repositories.ClientRepository;
import java.io.FileReader;
import java.io.Reader;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CsvService {
    private final ClientRepository clientRepository;
    @Value(value="${app.csv.path}")
    private String csvPath;

    public CsvService(ClientRepository clientRepository) {
        this.clientRepository = clientRepository;
    }

    @Transactional
    public void importCsv() {
        try (CSVReader reader = new CSVReader((Reader)new FileReader(this.csvPath));){
            String[] line;
            reader.readNext();
            HashSet<String> csvCodes = new HashSet<String>();
            while ((line = reader.readNext()) != null) {
                Client client;
                String codeClt = line[0].trim();
                String description = line[1].trim();
                String numContrat = line[2].trim();
                csvCodes.add(codeClt);
                Optional optionalClient = this.clientRepository.findById(codeClt);
                if (optionalClient.isPresent()) {
                    client = (Client)optionalClient.get();
                    client.setDescription(description);
                    client.setNumContrat(numContrat);
                } else {
                    client = new Client();
                    client.setCodeClt(codeClt);
                    client.setDescription(description);
                    client.setNumContrat(numContrat);
                }
                this.clientRepository.save(client);
            }
            List allClients = this.clientRepository.findAll();
            for (Client client : allClients) {
                if (csvCodes.contains(client.getCodeClt())) continue;
                this.clientRepository.delete(client);
                System.out.println("\ud83d\uddd1\ufe0f Client supprim\u00e9 : " + client.getCodeClt());
            }
        }
        catch (Exception e) {
            System.err.println("Erreur lors de l'import du CSV : " + e.getMessage());
            e.printStackTrace();
        }
    }
}

