/*
 * Decompiled with CFR 0.152.
 */
package com.smldb2.demo.services;

import com.smldb2.demo.services.CsvService;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class CsvWatcher {
    private final CsvService csvService;
    @Value(value="${app.csv.path}")
    private String csvPath;

    public CsvWatcher(CsvService csvService) {
        this.csvService = csvService;
    }

    @EventListener(value={ApplicationReadyEvent.class})
    @Async
    public void watchCsvFile() {
        try {
            WatchKey key;
            boolean valid;
            Path csvFile = Paths.get(this.csvPath, new String[0]);
            Path directory = csvFile.getParent();
            String fileName = csvFile.getFileName().toString();
            WatchService watchService = FileSystems.getDefault().newWatchService();
            directory.register(watchService, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_CREATE);
            System.out.println(" Surveillance du fichier : " + this.csvPath);
            do {
                try {
                    key = watchService.take();
                }
                catch (InterruptedException e) {
                    System.err.println("Service de surveillance interrompu");
                    return;
                }
                for (WatchEvent<?> event : key.pollEvents()) {
                    if (!event.context().toString().equals(fileName)) continue;
                    System.out.println("\ud83d\udcc1 Fichier CSV modifi\u00e9, mise \u00e0 jour de la base...");
                    Thread.sleep(500L);
                    this.csvService.importCsv();
                    System.out.println("\u2705 Base de donn\u00e9es mise \u00e0 jour");
                }
            } while (valid = key.reset());
            System.err.println("Le r\u00e9pertoire surveill\u00e9 n'est plus accessible");
        }
        catch (IOException e) {
            System.err.println("Erreur lors de la surveillance du fichier : " + e.getMessage());
            e.printStackTrace();
        }
        catch (Exception e) {
            System.err.println("Erreur inattendue : " + e.getMessage());
            e.printStackTrace();
        }
    }
}

