/*
 * Decompiled with CFR 0.152.
 */
package com.smldb2.demo.services;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.smldb2.demo.Entity.Famille;
import com.smldb2.demo.Entity.Prestataire;
import com.smldb2.demo.Entity.RapportContreVisite;
import com.smldb2.demo.Entity.Remboursement;
import com.smldb2.demo.Entity.User;
import com.smldb2.demo.repositories.FamilleRepository;
import com.smldb2.demo.repositories.PrestataireRepository;
import com.smldb2.demo.repositories.RapportContreVisiteRepository;
import com.smldb2.demo.repositories.RemboursementRepository;
import com.smldb2.demo.repositories.UserRepository;
import com.smldb2.demo.services.RapportEmailService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class RapportContreVisiteService {
    @Autowired
    private RapportContreVisiteRepository rapportRepository;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private FamilleRepository familleRepository;
    @Autowired
    private RemboursementRepository remboursementRepository;
    @Autowired
    private PrestataireRepository prestataireRepository;
    @Autowired
    private RapportEmailService rapportEmailService;
    @Autowired
    private ObjectMapper objectMapper;

    public Map<String, Object> creerRapportPourRemboursement(String prestataireId, String refBsPhys, String beneficiaireNom, MultipartFile image, RapportContreVisite rapport) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        try {
            String nomBeneficiaire;
            String typeBeneficiaire;
            Optional prestataireOpt = this.prestataireRepository.findById(prestataireId);
            if (!prestataireOpt.isPresent()) {
                response.put("success", false);
                response.put("message", "Prestataire introuvable");
                return response;
            }
            Prestataire prestataire = (Prestataire)prestataireOpt.get();
            Optional rembOpt = this.remboursementRepository.findById(refBsPhys);
            if (!rembOpt.isPresent()) {
                response.put("success", false);
                response.put("message", "Bulletin de soins introuvable");
                return response;
            }
            Remboursement remboursement = (Remboursement)rembOpt.get();
            String persoId = remboursement.getPersoId();
            Optional userOpt = this.userRepository.findById(persoId);
            if (!userOpt.isPresent()) {
                response.put("success", false);
                response.put("message", "Adh\u00e9rent introuvable");
                return response;
            }
            User user = (User)userOpt.get();
            if (beneficiaireNom.equalsIgnoreCase(user.getPersoName())) {
                typeBeneficiaire = "ADHERENT";
                nomBeneficiaire = user.getPersoName();
            } else {
                List<Famille> familles = this.familleRepository.findByPersoId(persoId);
                Famille famille = familles.stream().filter(f -> f.getPrenomPrestataire().equalsIgnoreCase(beneficiaireNom)).findFirst().orElse(null);
                if (famille != null) {
                    typeBeneficiaire = famille.getTypPrestataire().name();
                    nomBeneficiaire = famille.getPrenomPrestataire();
                } else {
                    response.put("success", false);
                    response.put("message", "B\u00e9n\u00e9ficiaire non trouv\u00e9 dans la famille de l'adh\u00e9rent");
                    return response;
                }
            }
            rapport.setPrestataireId(prestataireId);
            rapport.setRefBsPhys(refBsPhys);
            rapport.setBeneficiaireId(persoId);
            rapport.setBeneficiaireNom(nomBeneficiaire);
            rapport.setTypeBeneficiaire(typeBeneficiaire);
            if (!prestataire.getRole().equalsIgnoreCase(rapport.getTypeRapport())) {
                response.put("success", false);
                response.put("message", "Le type de rapport doit correspondre au r\u00f4le du prestataire");
                return response;
            }
            RapportContreVisite saved = (RapportContreVisite)this.rapportRepository.save(rapport);
            if (image != null && !image.isEmpty()) {
                this.rapportEmailService.sendRapportEmail(saved, prestataire, image);
            }
            response.put("success", true);
            response.put("message", "Rapport cr\u00e9\u00e9 avec succ\u00e8s");
            response.put("rapport", saved);
        }
        catch (Exception e) {
            e.printStackTrace();
            response.put("success", false);
            response.put("message", "Erreur: " + e.getMessage());
        }
        return response;
    }

    public List<Map<String, String>> getRapportsAvecType(String prestataireId) {
        List<RapportContreVisite> rapports = this.rapportRepository.findByPrestataireId(prestataireId);
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        for (RapportContreVisite r : rapports) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("id", r.getId().toString());
            map.put("refBsPhys", r.getRefBsPhys());
            map.put("beneficiaireNom", r.getBeneficiaireNom());
            map.put("typeBeneficiaire", r.getTypeBeneficiaire().equalsIgnoreCase("ADHERENT") ? "Adh\u00e9rent" : r.getTypeBeneficiaire());
            result.add(map);
        }
        return result;
    }

    public List<Remboursement> getRemboursementsByUser(String persoId) {
        return this.remboursementRepository.findByPersoId(persoId);
    }

    public List<User> getAllAdherents() {
        return this.userRepository.findAll();
    }

    public List<Famille> getFamilleByUser(String persoId) {
        return this.familleRepository.findByPersoId(persoId);
    }

    public User getAdherentByMatricule(String matricule) {
        return this.userRepository.findByCin(matricule).orElse(null);
    }

    public Map<String, Object> creerRapportParMatricule(String matriculeAdherent, String refBsPhys, String prestataireId, MultipartFile image, RapportContreVisite rapport) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        try {
            Optional<User> userOpt = this.userRepository.findByCin(matriculeAdherent);
            if (!userOpt.isPresent()) {
                response.put("success", false);
                response.put("message", "Aucun adh\u00e9rent trouv\u00e9 avec cette matricule (CIN)");
                return response;
            }
            User user = userOpt.get();
            Optional rembOpt = this.remboursementRepository.findById(refBsPhys);
            if (!rembOpt.isPresent()) {
                response.put("success", false);
                response.put("message", "Remboursement introuvable");
                return response;
            }
            Optional prestataireOpt = this.prestataireRepository.findById(prestataireId);
            if (!prestataireOpt.isPresent()) {
                response.put("success", false);
                response.put("message", "Prestataire introuvable");
                return response;
            }
            Prestataire prestataire = (Prestataire)prestataireOpt.get();
            rapport.setPrestataireId(prestataireId);
            rapport.setBeneficiaireId(user.getPersoId());
            rapport.setBeneficiaireNom(user.getPersoName());
            rapport.setTypeBeneficiaire("ADHERENT");
            rapport.setRefBsPhys(refBsPhys);
            rapport.setDateRapport(new Date());
            if (!prestataire.getRole().equalsIgnoreCase(rapport.getTypeRapport())) {
                response.put("success", false);
                response.put("message", "Le type de rapport ne correspond pas au r\u00f4le du prestataire");
                return response;
            }
            RapportContreVisite saved = (RapportContreVisite)this.rapportRepository.save(rapport);
            if (image != null && !image.isEmpty()) {
                this.rapportEmailService.sendRapportEmail(saved, prestataire, image);
            }
            response.put("success", true);
            response.put("message", "Rapport cr\u00e9\u00e9 avec succ\u00e8s");
            response.put("rapport", saved);
        }
        catch (Exception e) {
            e.printStackTrace();
            response.put("success", false);
            response.put("message", "Erreur : " + e.getMessage());
        }
        return response;
    }

    public Map<String, String> getBeneficiaireParRefBsPhys(String refBsPhys) throws Exception {
        Remboursement remboursement = (Remboursement)this.remboursementRepository.findById(refBsPhys).orElseThrow(() -> new Exception("Remboursement introuvable"));
        String persoIdRemb = remboursement.getPersoId();
        String nomPrenRemb = remboursement.getNomPrenPrest();
        User user = (User)this.userRepository.findById(persoIdRemb).orElseThrow(() -> new Exception("Adh\u00e9rent introuvable"));
        List<Famille> familles = this.familleRepository.findByPersoId(persoIdRemb);
        String typeBeneficiaire = "ADHERENT";
        for (Famille f : familles) {
            if (f.getPersoId() == null || !f.getPersoId().equalsIgnoreCase(persoIdRemb) || f.getPrenomPrestataire() == null || !f.getPrenomPrestataire().trim().equalsIgnoreCase(nomPrenRemb.trim())) continue;
            if (f.getTypPrestataire() == null) break;
            typeBeneficiaire = f.getTypPrestataire().name();
            break;
        }
        HashMap<String, String> beneficiaireMap = new HashMap<String, String>();
        beneficiaireMap.put("nom", nomPrenRemb);
        beneficiaireMap.put("type", typeBeneficiaire);
        return beneficiaireMap;
    }

    public List<Map<String, Object>> getRapportsByBeneficiaireId(String beneficiaireId) {
        List<RapportContreVisite> rapports = this.rapportRepository.findByBeneficiaireId(beneficiaireId);
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        for (RapportContreVisite rapport : rapports) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("beneficiaireNom", rapport.getBeneficiaireNom());
            map.put("dateRapport", rapport.getDateRapport());
            map.put("typeRapport", rapport.getTypeRapport());
            map.put("refBsPhys", rapport.getRefBsPhys());
            Optional prestataireOpt = this.prestataireRepository.findById(rapport.getPrestataireId());
            if (prestataireOpt.isPresent()) {
                Prestataire p = (Prestataire)prestataireOpt.get();
                map.put("prestataireNom", p.getNom());
                map.put("prestataireContact", p.getContact());
                map.put("prestataireAdresse", p.getAdresse());
                map.put("prestataireMatriculeFiscale", p.getMatriculeFiscale());
            } else {
                map.put("prestataireNom", "Inconnu");
                map.put("prestataireContact", "");
                map.put("prestataireAdresse", "");
                map.put("prestataireMatriculeFiscale", "");
            }
            result.add(map);
        }
        return result;
    }

    public List<Map<String, Object>> getRapportsDetailsByPrestataire(String prestataireId) {
        List<RapportContreVisite> rapports = this.rapportRepository.findByPrestataireId(prestataireId);
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        for (RapportContreVisite rapport : rapports) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            try {
                Map<String, String> beneficiaireInfo = this.getBeneficiaireParRefBsPhys(rapport.getRefBsPhys());
                map.put("beneficiaireNom", rapport.getBeneficiaireNom());
                map.put("dateRapport", rapport.getDateRapport());
                map.put("refBsPhys", rapport.getRefBsPhys());
                map.put("observation", rapport.getObservation());
                map.put("type", beneficiaireInfo.get("type"));
            }
            catch (Exception e) {
                map.put("beneficiaireNom", rapport.getBeneficiaireNom());
                map.put("dateRapport", rapport.getDateRapport());
                map.put("refBsPhys", rapport.getRefBsPhys());
                map.put("observation", rapport.getObservation());
                map.put("type", "Inconnu");
            }
            result.add(map);
        }
        return result;
    }
}

