/*
 * Decompiled with CFR 0.152.
 */
package com.smldb2.demo.services;

import com.smldb2.demo.DTO.ReclamationDTO;
import com.smldb2.demo.Entity.Reclamation;
import com.smldb2.demo.Entity.Remboursement;
import com.smldb2.demo.Entity.User;
import com.smldb2.demo.repositories.ReclamationRepository;
import com.smldb2.demo.repositories.RemboursementRepository;
import com.smldb2.demo.repositories.UserRepository;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ReclamationService {
    @Autowired
    private ReclamationRepository reclamationRepository;
    @Autowired
    private RemboursementRepository remboursementRepository;
    @Autowired
    private UserRepository userRepository;
    private static final int MAX_RECLAMATIONS_PER_REMBOURSEMENT = 2;

    @Transactional
    public ReclamationDTO createReclamation(ReclamationDTO reclamationDTO) {
        Optional<Remboursement> remboursementOpt = this.remboursementRepository.findByRefBsPhys(reclamationDTO.getRefBsPhys());
        if (remboursementOpt.isEmpty()) {
            throw new RuntimeException("Remboursement introuvable avec la r\u00e9f\u00e9rence: " + reclamationDTO.getRefBsPhys());
        }
        Remboursement remboursement = remboursementOpt.get();
        if (!remboursement.getPersoId().equals(reclamationDTO.getPersoId())) {
            throw new RuntimeException("Ce remboursement n'appartient pas \u00e0 cet utilisateur");
        }
        long nombreReclamations = this.reclamationRepository.countByRefBsPhys(reclamationDTO.getRefBsPhys());
        System.out.println("\ud83d\udcca Nombre de r\u00e9clamations existantes pour " + reclamationDTO.getRefBsPhys() + ": " + nombreReclamations);
        if (nombreReclamations >= 2L) {
            throw new RuntimeException("LIMITE_ATTEINTE:Vous avez atteint la limite de 2 r\u00e9clamations pour ce remboursement. Veuillez consulter votre responsable RH.");
        }
        Optional userOpt = this.userRepository.findById(reclamationDTO.getPersoId());
        if (userOpt.isEmpty()) {
            throw new RuntimeException("Utilisateur introuvable avec l'ID: " + reclamationDTO.getPersoId());
        }
        Reclamation reclamation = new Reclamation();
        reclamation.setRefBsPhys(reclamationDTO.getRefBsPhys());
        reclamation.setPersoId(reclamationDTO.getPersoId());
        reclamation.setTitreReclamation(reclamationDTO.getTitreReclamation());
        reclamation.setTexteReclamation(reclamationDTO.getTexteReclamation());
        reclamation.setDateCreation(new Date());
        reclamation.setExported("N");
        reclamation.setUser((User)userOpt.get());
        Reclamation savedReclamation = (Reclamation)this.reclamationRepository.save(reclamation);
        System.out.println("\u2705 R\u00e9clamation cr\u00e9\u00e9e avec succ\u00e8s. Total pour ce BS: " + (nombreReclamations + 1L) + "/2");
        return this.convertToDTO(savedReclamation, remboursement);
    }

    public int countReclamationsByRefBsPhys(String refBsPhys) {
        return (int)this.reclamationRepository.countByRefBsPhys(refBsPhys);
    }

    public boolean canCreateReclamation(String refBsPhys) {
        long count = this.reclamationRepository.countByRefBsPhys(refBsPhys);
        return count < 2L;
    }

    public List<ReclamationDTO> getReclamationsByUser(String persoId) {
        List<Reclamation> reclamations = this.reclamationRepository.findByPersoId(persoId);
        return reclamations.stream().map(reclamation -> {
            Optional<Remboursement> remboursement = this.remboursementRepository.findByRefBsPhys(reclamation.getRefBsPhys());
            return this.convertToDTO((Reclamation)reclamation, remboursement.orElse(null));
        }).collect(Collectors.toList());
    }

    public ReclamationDTO getReclamationById(Long numReclamation) {
        Optional reclamationOpt = this.reclamationRepository.findById(numReclamation);
        if (reclamationOpt.isEmpty()) {
            throw new RuntimeException("R\u00e9clamation introuvable avec l'ID: " + numReclamation);
        }
        Reclamation reclamation = (Reclamation)reclamationOpt.get();
        Optional<Remboursement> remboursement = this.remboursementRepository.findByRefBsPhys(reclamation.getRefBsPhys());
        return this.convertToDTO(reclamation, remboursement.orElse(null));
    }

    public List<ReclamationDTO> getReclamationsByRefBsPhys(String refBsPhys) {
        List<Reclamation> reclamations = this.reclamationRepository.findByRefBsPhys(refBsPhys);
        Optional<Remboursement> remboursement = this.remboursementRepository.findByRefBsPhys(refBsPhys);
        return reclamations.stream().map(reclamation -> this.convertToDTO((Reclamation)reclamation, remboursement.orElse(null))).collect(Collectors.toList());
    }

    public boolean hasReclamation(String refBsPhys) {
        return this.reclamationRepository.existsByRefBsPhys(refBsPhys);
    }

    public List<Remboursement> getRemboursementsByUser(String persoId) {
        return this.remboursementRepository.findByPersoId(persoId);
    }

    private ReclamationDTO convertToDTO(Reclamation reclamation, Remboursement remboursement) {
        ReclamationDTO dto = new ReclamationDTO();
        dto.setNumReclamation(reclamation.getNumReclamation());
        dto.setRefBsPhys(reclamation.getRefBsPhys());
        dto.setPersoId(reclamation.getPersoId());
        dto.setTitreReclamation(reclamation.getTitreReclamation());
        dto.setTexteReclamation(reclamation.getTexteReclamation());
        dto.setResponseRec(reclamation.getResponseRec());
        dto.setExported(reclamation.getExported());
        dto.setDateCreation(reclamation.getDateCreation());
        if (remboursement != null) {
            dto.setNomPrenPrest(remboursement.getNomPrenPrest());
            dto.setDatBs(remboursement.getDatBs());
        }
        return dto;
    }

    @Transactional
    public void deleteReclamation(Long numReclamation) {
        if (!this.reclamationRepository.existsById(numReclamation)) {
            throw new RuntimeException("R\u00e9clamation introuvable avec l'ID: " + numReclamation);
        }
        this.reclamationRepository.deleteById(numReclamation);
    }

    @Transactional
    public ReclamationDTO updateReclamationResponse(Long numReclamation, String response) {
        Optional reclamationOpt = this.reclamationRepository.findById(numReclamation);
        if (reclamationOpt.isEmpty()) {
            throw new RuntimeException("R\u00e9clamation introuvable avec l'ID: " + numReclamation);
        }
        Reclamation reclamation = (Reclamation)reclamationOpt.get();
        reclamation.setResponseRec(response);
        Reclamation updatedReclamation = (Reclamation)this.reclamationRepository.save(reclamation);
        Optional<Remboursement> remboursement = this.remboursementRepository.findByRefBsPhys(reclamation.getRefBsPhys());
        return this.convertToDTO(updatedReclamation, remboursement.orElse(null));
    }
}

