/*
 * Decompiled with CFR 0.152.
 */
package com.smldb2.demo.services;

import com.smldb2.demo.DTO.ActeAnnuelDTO;
import com.smldb2.demo.DTO.ReportingAnnuelDTO;
import com.smldb2.demo.DTO.StatistiquesPrestataireDTO;
import com.smldb2.demo.Entity.Famille;
import com.smldb2.demo.Entity.User;
import com.smldb2.demo.repositories.RemboursementRepository;
import com.smldb2.demo.repositories.StatActAnnRepository;
import com.smldb2.demo.repositories.UserRepository;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.ZoneId;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StatActAnnService {
    @Autowired
    private StatActAnnRepository statActAnnRepository;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private RemboursementRepository remboursementRepository;

    public List<Integer> getAllAnnees() {
        return this.statActAnnRepository.findAllDistinctAnnees();
    }

    public List<String> getAllSocietes() {
        return this.statActAnnRepository.findAllDistinctSocietes();
    }

    public ReportingAnnuelDTO getReportingAnnuel(Integer annee, String codeSociete) {
        List<Object[]> statsActes = this.statActAnnRepository.findStatistiquesActesByAnneeAndSociete(annee, codeSociete);
        List<ActeAnnuelDTO> actes = statsActes.stream().map(row -> {
            String acte = (String)row[0];
            BigDecimal depense = row[1] != null ? (BigDecimal)row[1] : BigDecimal.ZERO;
            BigDecimal rembourse = row[2] != null ? (BigDecimal)row[2] : BigDecimal.ZERO;
            BigDecimal difference = depense.subtract(rembourse);
            Double pourcentage = depense.compareTo(BigDecimal.ZERO) > 0 ? rembourse.divide(depense, 4, RoundingMode.HALF_UP).multiply(BigDecimal.valueOf(100L)).doubleValue() : 0.0;
            return new ActeAnnuelDTO(acte, depense, rembourse, difference, pourcentage);
        }).collect(Collectors.toList());
        List<Object[]> statsGlobalesList = this.statActAnnRepository.findStatistiquesGlobales(annee, codeSociete);
        BigDecimal totalDepense = BigDecimal.ZERO;
        BigDecimal totalRembourse = BigDecimal.ZERO;
        Long nombreActes = 0L;
        if (!statsGlobalesList.isEmpty()) {
            Object[] statsGlobales = statsGlobalesList.get(0);
            totalDepense = statsGlobales[0] != null ? (BigDecimal)statsGlobales[0] : BigDecimal.ZERO;
            totalRembourse = statsGlobales[1] != null ? (BigDecimal)statsGlobales[1] : BigDecimal.ZERO;
            nombreActes = statsGlobales[2] != null ? ((Number)statsGlobales[2]).longValue() : 0L;
        }
        BigDecimal difference = totalDepense.subtract(totalRembourse);
        Double pourcentageGlobal = totalDepense.compareTo(BigDecimal.ZERO) > 0 ? totalRembourse.divide(totalDepense, 4, RoundingMode.HALF_UP).multiply(BigDecimal.valueOf(100L)).doubleValue() : 0.0;
        StatistiquesPrestataireDTO statsPrestataire = this.calculerStatistiquesPrestataire(annee, codeSociete);
        return new ReportingAnnuelDTO(annee, codeSociete, totalDepense, totalRembourse, difference, pourcentageGlobal, nombreActes.intValue(), actes, statsPrestataire);
    }

    private StatistiquesPrestataireDTO calculerStatistiquesPrestataire(Integer annee, String codeSociete) {
        List usersActifs = this.userRepository.findAll().stream().filter(u -> "ACTIF".equalsIgnoreCase(u.getPosition())).collect(Collectors.toList());
        int nombreAdherents = 0;
        int enfant01Count = 0;
        int enfant02Count = 0;
        int enfant03Count = 0;
        int enfant04Count = 0;
        int enfant05Count = 0;
        int conjoint98Count = 0;
        int conjoint99Count = 0;
        int adherentCount = 0;
        for (User user : usersActifs) {
            long countRemb;
            int i;
            List remboursementsUser = user.getRemboursements().stream().filter(r -> codeSociete.equalsIgnoreCase(r.getCodeEntreprise()) && r.getDatBs() != null && this.getYear(r.getDatBs()) == annee.intValue()).collect(Collectors.toList());
            if (remboursementsUser.isEmpty()) continue;
            ++nombreAdherents;
            long adherentRemb = remboursementsUser.stream().filter(r -> r.getNomPrenPrest() != null && r.getNomPrenPrest().equalsIgnoreCase(user.getPersoName())).count();
            adherentCount = (int)((long)adherentCount + adherentRemb);
            List<Famille> familles = user.getFamilles();
            List enfants = familles.stream().filter(f -> f.getTypPrestataire() != null && "ENFANT".equalsIgnoreCase(f.getTypPrestataire().name())).collect(Collectors.toList());
            List conjoints = familles.stream().filter(f -> f.getTypPrestataire() != null && "CONJOINT".equalsIgnoreCase(f.getTypPrestataire().name())).collect(Collectors.toList());
            block8: for (i = 0; i < Math.min(enfants.size(), 5); ++i) {
                Famille enfant = (Famille)enfants.get(i);
                countRemb = remboursementsUser.stream().filter(r -> r.getNomPrenPrest() != null && r.getNomPrenPrest().equalsIgnoreCase(enfant.getPrenomPrestataire())).count();
                switch (i) {
                    case 0: {
                        enfant01Count = (int)((long)enfant01Count + countRemb);
                        continue block8;
                    }
                    case 1: {
                        enfant02Count = (int)((long)enfant02Count + countRemb);
                        continue block8;
                    }
                    case 2: {
                        enfant03Count = (int)((long)enfant03Count + countRemb);
                        continue block8;
                    }
                    case 3: {
                        enfant04Count = (int)((long)enfant04Count + countRemb);
                        continue block8;
                    }
                    case 4: {
                        enfant05Count = (int)((long)enfant05Count + countRemb);
                    }
                }
            }
            for (i = 0; i < Math.min(conjoints.size(), 2); ++i) {
                Famille conjoint = (Famille)conjoints.get(i);
                countRemb = remboursementsUser.stream().filter(r -> r.getNomPrenPrest() != null && r.getNomPrenPrest().equalsIgnoreCase(conjoint.getPrenomPrestataire())).count();
                if (i == 0) {
                    conjoint98Count = (int)((long)conjoint98Count + countRemb);
                    continue;
                }
                conjoint99Count = (int)((long)conjoint99Count + countRemb);
            }
        }
        return new StatistiquesPrestataireDTO(nombreAdherents, adherentCount, enfant01Count, enfant02Count, enfant03Count, enfant04Count, enfant05Count, conjoint98Count, conjoint99Count);
    }

    private int getYear(Date date) {
        if (date == null) {
            return 0;
        }
        return date.toInstant().atZone(ZoneId.systemDefault()).getYear();
    }
}

