/*
 * Decompiled with CFR 0.152.
 */
package com.smldb2.demo.services;

import com.smldb2.demo.DTO.ActeDetailDTO;
import com.smldb2.demo.DTO.ReportingResponseDTO;
import com.smldb2.demo.DTO.StatActeDTO;
import com.smldb2.demo.DTO.StatAdherentDTO;
import com.smldb2.demo.Entity.StatActDate;
import com.smldb2.demo.Entity.User;
import com.smldb2.demo.repositories.StatActDateRepository;
import com.smldb2.demo.repositories.UserRepository;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StatActDateService {
    @Autowired
    private StatActDateRepository statActDateRepository;
    @Autowired
    private UserRepository userRepository;
    private final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd/MM/yyyy");

    public List<String> getAllSocietes() {
        return this.statActDateRepository.findAllDistinctCodeSociete();
    }

    public ReportingResponseDTO getReportingBySocieteAndPeriode(String codeSociete, LocalDate dateDebut, LocalDate dateFin) {
        List<Object[]> statsAdherents = this.statActDateRepository.findStatistiquesParAdherent(codeSociete, dateDebut, dateFin);
        List<StatAdherentDTO> adherents = statsAdherents.stream().map(row -> {
            String matricule = (String)row[0];
            BigDecimal depense = (BigDecimal)row[1];
            BigDecimal rembourse = (BigDecimal)row[2];
            Long nombreActes = (Long)row[3];
            BigDecimal difference = depense.subtract(rembourse);
            Double pourcentage = depense.compareTo(BigDecimal.ZERO) > 0 ? rembourse.divide(depense, 4, RoundingMode.HALF_UP).multiply(BigDecimal.valueOf(100L)).doubleValue() : 0.0;
            String nomAdherent = "";
            Integer nombreFamille = 0;
            BigDecimal plafondGlobal = BigDecimal.ZERO;
            Optional<User> userOpt = this.userRepository.findByCin(matricule);
            if (userOpt.isPresent()) {
                User user = userOpt.get();
                nomAdherent = user.getPersoName();
                nombreFamille = user.getFamilles() != null ? user.getFamilles().size() : 0;
                int totalPersonnes = 1 + nombreFamille;
                plafondGlobal = BigDecimal.valueOf(7000000L).multiply(BigDecimal.valueOf(totalPersonnes));
            }
            return new StatAdherentDTO(matricule, nomAdherent, nombreFamille, depense, rembourse, difference, pourcentage, nombreActes, plafondGlobal);
        }).collect(Collectors.toList());
        List<Object[]> statsActes = this.statActDateRepository.findStatistiquesActesBySocieteAndPeriode(codeSociete, dateDebut, dateFin);
        List<StatActeDTO> actes = statsActes.stream().map(row -> {
            String acte = (String)row[0];
            BigDecimal depense = (BigDecimal)row[1];
            BigDecimal rembourse = (BigDecimal)row[2];
            Long nombreActes = (Long)row[3];
            BigDecimal difference = depense.subtract(rembourse);
            Double pourcentage = depense.compareTo(BigDecimal.ZERO) > 0 ? rembourse.divide(depense, 4, RoundingMode.HALF_UP).multiply(BigDecimal.valueOf(100L)).doubleValue() : 0.0;
            return new StatActeDTO(acte, depense, rembourse, difference, pourcentage, nombreActes);
        }).collect(Collectors.toList());
        BigDecimal totalDepense = adherents.stream().map(StatAdherentDTO::getDepense).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totalRembourse = adherents.stream().map(StatAdherentDTO::getRembourse).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal difference = totalDepense.subtract(totalRembourse);
        Double pourcentageGlobal = totalDepense.compareTo(BigDecimal.ZERO) > 0 ? totalRembourse.divide(totalDepense, 4, RoundingMode.HALF_UP).multiply(BigDecimal.valueOf(100L)).doubleValue() : 0.0;
        Integer nombreActesTotal = adherents.stream().map(StatAdherentDTO::getNombreActes).mapToInt(Long::intValue).sum();
        return new ReportingResponseDTO(totalDepense, totalRembourse, difference, pourcentageGlobal, adherents.size(), nombreActesTotal, adherents, actes);
    }

    public List<ActeDetailDTO> getActesByMatricule(String matricule, String codeSociete, LocalDate dateDebut, LocalDate dateFin) {
        List<StatActDate> actes = this.statActDateRepository.findActesByMatriculeAndPeriode(matricule, codeSociete, dateDebut, dateFin);
        return actes.stream().map(acte -> {
            String dateFormatted = acte.getDateBs().format(this.formatter);
            Double pourcentage = acte.getDepense().compareTo(BigDecimal.ZERO) > 0 ? acte.getRembourse().divide(acte.getDepense(), 4, RoundingMode.HALF_UP).multiply(BigDecimal.valueOf(100L)).doubleValue() : 0.0;
            ActeDetailDTO dto = new ActeDetailDTO();
            dto.setActe(acte.getActe());
            dto.setDateBs(dateFormatted);
            dto.setDepense(acte.getDepense());
            dto.setRembourse(acte.getRembourse());
            dto.setPourcentageRemboursement(pourcentage);
            return dto;
        }).collect(Collectors.toList());
    }

    public List<String> getMatriculesBySocieteAndPeriode(String codeSociete, LocalDate dateDebut, LocalDate dateFin) {
        return this.statActDateRepository.findMatriculesBySocieteAndPeriode(codeSociete, dateDebut, dateFin);
    }
}

