/*
 * Decompiled with CFR 0.152.
 */
package com.smldb2.demo.services;

import com.smldb2.demo.DTO.UserDetailedStatsDTO;
import com.smldb2.demo.DTO.UserStatsDTO;
import com.smldb2.demo.Entity.Rib;
import com.smldb2.demo.Entity.Tel;
import com.smldb2.demo.Entity.User;
import com.smldb2.demo.repositories.RibRepository;
import com.smldb2.demo.repositories.TelRepository;
import com.smldb2.demo.repositories.UserRepository;
import java.security.MessageDigest;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UserService {
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private RibRepository ribRepository;
    @Autowired
    private TelRepository telRepository;

    public Optional<User> getUserByName(String name) {
        return this.userRepository.findByPersoName(name);
    }

    public List<User> getUsersByEmail(String email) {
        return this.userRepository.findByEmailContaining(email);
    }

    public List<User> getUsersBySexe(String sexe) {
        return this.userRepository.findBySexe(sexe);
    }

    private String md5(String input) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] messageDigest = md.digest(input.getBytes());
            StringBuilder sb = new StringBuilder();
            for (byte b : messageDigest) {
                sb.append(String.format("%02X", b));
            }
            return sb.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Optional<User> login(String persoId, String password) {
        String hashedPassword = this.md5(password);
        return this.userRepository.findByPersoIdAndPersoPassed(persoId, hashedPassword);
    }

    private int calculateAge(Date birthDate) {
        LocalDate birth = birthDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        LocalDate now = LocalDate.now();
        return Period.between(birth, now).getYears();
    }

    public List<String> getAllCompanyCodes() {
        return this.userRepository.findAllDistinctCompanyCodes();
    }

    public UserStatsDTO getGlobalStats() {
        System.out.println("\ud83d\udcca D\u00e9but de getGlobalStats (toutes entreprises)");
        long total = this.userRepository.count();
        System.out.println("\u2705 Total adh\u00e9rents: " + total);
        long nouveaux = 0L;
        try {
            LocalDate firstDayOfMonth = LocalDate.now().withDayOfMonth(1);
            Date startOfMonth = Date.from(firstDayOfMonth.atStartOfDay(ZoneId.systemDefault()).toInstant());
            nouveaux = this.userRepository.countByDateCreationAfter(startOfMonth);
            System.out.println("\u2705 Nouveaux adh\u00e9rents ce mois: " + nouveaux);
        }
        catch (Exception e) {
            System.err.println("\u26a0\ufe0f Impossible de calculer les nouveaux adh\u00e9rents: " + e.getMessage());
            nouveaux = 0L;
        }
        UserStatsDTO stats = new UserStatsDTO(total, nouveaux);
        return stats;
    }

    public UserDetailedStatsDTO getDetailedStats() {
        System.out.println("\ud83d\udcca D\u00e9but de getDetailedStats (toutes entreprises)");
        List allUsers = this.userRepository.findAll();
        return this.calculateDetailedStats(allUsers);
    }

    public Map<String, Long> getMonthlyEvolution() {
        List allUsers = this.userRepository.findAll();
        return this.calculateMonthlyEvolution(allUsers);
    }

    public UserStatsDTO getGlobalStatsByCompany(String codeEntreprise) {
        System.out.println("\ud83d\udcca D\u00e9but de getGlobalStatsByCompany pour: " + codeEntreprise);
        long total = this.userRepository.countByCodeEntreprise(codeEntreprise);
        System.out.println("\u2705 Total adh\u00e9rents entreprise " + codeEntreprise + ": " + total);
        long nouveaux = 0L;
        try {
            LocalDate firstDayOfMonth = LocalDate.now().withDayOfMonth(1);
            Date startOfMonth = Date.from(firstDayOfMonth.atStartOfDay(ZoneId.systemDefault()).toInstant());
            nouveaux = this.userRepository.countByCodeEntrepriseAndDateCreationAfter(codeEntreprise, startOfMonth);
            System.out.println("\u2705 Nouveaux adh\u00e9rents entreprise " + codeEntreprise + " ce mois: " + nouveaux);
        }
        catch (Exception e) {
            System.err.println("\u26a0\ufe0f Impossible de calculer les nouveaux adh\u00e9rents: " + e.getMessage());
            nouveaux = 0L;
        }
        UserStatsDTO stats = new UserStatsDTO(total, nouveaux);
        return stats;
    }

    public UserDetailedStatsDTO getDetailedStatsByCompany(String codeEntreprise) {
        System.out.println("\ud83d\udcca D\u00e9but de getDetailedStatsByCompany pour: " + codeEntreprise);
        List<User> companyUsers = this.userRepository.findByCodeEntreprise(codeEntreprise);
        System.out.println("\u2705 Nombre d'utilisateurs de l'entreprise " + codeEntreprise + ": " + companyUsers.size());
        return this.calculateDetailedStats(companyUsers);
    }

    public Map<String, Long> getMonthlyEvolutionByCompany(String codeEntreprise) {
        List<User> companyUsers = this.userRepository.findByCodeEntreprise(codeEntreprise);
        return this.calculateMonthlyEvolution(companyUsers);
    }

    private UserDetailedStatsDTO calculateDetailedStats(List<User> users) {
        HashMap<String, Long> repartitionParSexe = new HashMap<String, Long>();
        repartitionParSexe.put("M", 0L);
        repartitionParSexe.put("F", 0L);
        repartitionParSexe.put("AUTRE", 0L);
        HashMap<String, Long> repartitionParSituationFamiliale = new HashMap<String, Long>();
        for (User user : users) {
            String sexe = user.getSexe();
            if (sexe != null && !sexe.isEmpty()) {
                if (sexe.equalsIgnoreCase("M") || sexe.equalsIgnoreCase("HOMME") || sexe.equalsIgnoreCase("H")) {
                    repartitionParSexe.put("M", (Long)repartitionParSexe.get("M") + 1L);
                } else if (sexe.equalsIgnoreCase("F") || sexe.equalsIgnoreCase("FEMME")) {
                    repartitionParSexe.put("F", (Long)repartitionParSexe.get("F") + 1L);
                } else {
                    repartitionParSexe.put("AUTRE", (Long)repartitionParSexe.get("AUTRE") + 1L);
                }
            } else {
                repartitionParSexe.put("AUTRE", (Long)repartitionParSexe.get("AUTRE") + 1L);
            }
            String situation = user.getSituationFamiliale();
            if (situation != null && !situation.isEmpty()) {
                String situationUpper = situation.toUpperCase().trim();
                repartitionParSituationFamiliale.put(situationUpper, repartitionParSituationFamiliale.getOrDefault(situationUpper, 0L) + 1L);
                continue;
            }
            repartitionParSituationFamiliale.put("NON_DEFINI", repartitionParSituationFamiliale.getOrDefault("NON_DEFINI", 0L) + 1L);
        }
        if ((Long)repartitionParSexe.get("AUTRE") == 0L) {
            repartitionParSexe.remove("AUTRE");
        }
        System.out.println("\ud83d\udcca R\u00e9partition par sexe: " + repartitionParSexe);
        System.out.println("\ud83d\udcca R\u00e9partition par situation: " + repartitionParSituationFamiliale);
        UserDetailedStatsDTO stats = new UserDetailedStatsDTO();
        stats.setRepartitionParSexe(repartitionParSexe);
        stats.setRepartitionParSituationFamiliale(repartitionParSituationFamiliale);
        return stats;
    }

    private Map<String, Long> calculateMonthlyEvolution(List<User> users) {
        TreeMap<String, Long> monthlyCount = new TreeMap<String, Long>();
        LocalDate now = LocalDate.now();
        for (int i = 11; i >= 0; --i) {
            LocalDate month = now.minusMonths(i);
            String monthKey = month.format(DateTimeFormatter.ofPattern("MMM yyyy", Locale.FRENCH));
            LocalDate startOfMonth = month.withDayOfMonth(1);
            LocalDate endOfMonth = month.withDayOfMonth(month.lengthOfMonth());
            Date startDate = Date.from(startOfMonth.atStartOfDay(ZoneId.systemDefault()).toInstant());
            Date endDate = Date.from(endOfMonth.atTime(23, 59, 59).atZone(ZoneId.systemDefault()).toInstant());
            long count = users.stream().filter(u -> u.getDateCreation() != null).filter(u -> !u.getDateCreation().before(startDate) && !u.getDateCreation().after(endDate)).count();
            monthlyCount.put(monthKey, count);
        }
        return monthlyCount;
    }

    public Map<String, Object> getRibByPersoId(String persoId) {
        try {
            HashMap<String, Object> response = new HashMap<String, Object>();
            Optional<User> userOpt = this.userRepository.findByPersoId(persoId);
            if (!userOpt.isPresent()) {
                throw new RuntimeException("Utilisateur non trouv\u00e9");
            }
            User user = userOpt.get();
            String ribActuel = user.getRib();
            List<Rib> ribsEnAttente = this.ribRepository.findByPersoIdAndExported(persoId, "N");
            if (!ribsEnAttente.isEmpty()) {
                Rib ribEnAttente = ribsEnAttente.get(0);
                response.put("persoId", persoId);
                response.put("rib", ribEnAttente.getNouveauRib());
                response.put("ancienRib", ribEnAttente.getAncienRib());
                response.put("enAttente", true);
                LocalTime now = LocalTime.now();
                LocalTime cutoffTime = LocalTime.of(11, 10);
                LocalDateTime creationDateTime = ribEnAttente.getDateCreation().toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
                LocalTime creationTime = creationDateTime.toLocalTime();
                LocalDate creationDate = creationDateTime.toLocalDate();
                LocalDate today = LocalDate.now();
                String message = creationDate.equals(today) && creationTime.isBefore(cutoffTime) && now.isBefore(cutoffTime) ? "Votre RIB sera modifi\u00e9 aujourd'hui \u00e0 11h10" : "Votre RIB sera modifi\u00e9 demain \u00e0 11h10";
                response.put("message", message);
                System.out.println("\ud83d\udccb RIB en attente trouv\u00e9 pour " + persoId);
                System.out.println("   Ancien: " + ribEnAttente.getAncienRib());
                System.out.println("   Nouveau: " + ribEnAttente.getNouveauRib());
                System.out.println("   Cr\u00e9\u00e9 \u00e0: " + creationTime);
            } else {
                response.put("persoId", persoId);
                response.put("rib", ribActuel != null ? ribActuel : "");
                response.put("enAttente", false);
                System.out.println("\ud83d\udccb RIB actif retourn\u00e9 pour " + persoId + ": " + ribActuel);
            }
            return response;
        }
        catch (Exception e) {
            System.err.println("\u274c Erreur lors de la r\u00e9cup\u00e9ration du RIB pour " + persoId + ": " + e.getMessage());
            throw new RuntimeException("Erreur lors de la r\u00e9cup\u00e9ration du RIB", e);
        }
    }

    @Transactional
    public Map<String, Object> updateRib(String persoId, String newRib) {
        try {
            HashMap<String, Object> response = new HashMap<String, Object>();
            Optional<User> userOpt = this.userRepository.findByPersoId(persoId);
            if (!userOpt.isPresent()) {
                response.put("success", false);
                response.put("message", "Utilisateur non trouv\u00e9");
                return response;
            }
            User user = userOpt.get();
            String ancienRib = user.getRib();
            if (newRib.equals(ancienRib)) {
                response.put("success", false);
                response.put("message", "Le nouveau RIB est identique \u00e0 l'ancien");
                return response;
            }
            List<Rib> demandesExistantes = this.ribRepository.findByPersoIdAndExported(persoId, "N");
            if (!demandesExistantes.isEmpty()) {
                response.put("success", false);
                response.put("message", "Vous avez d\u00e9j\u00e0 une demande de changement de RIB en cours");
                return response;
            }
            Rib nouvelleDemandeRib = new Rib();
            nouvelleDemandeRib.setPersoId(persoId);
            nouvelleDemandeRib.setAncienRib(ancienRib);
            nouvelleDemandeRib.setNouveauRib(newRib);
            nouvelleDemandeRib.setExported("N");
            nouvelleDemandeRib.setDateCreation(new Date());
            this.ribRepository.save(nouvelleDemandeRib);
            LocalTime now = LocalTime.now();
            LocalTime cutoffTime = LocalTime.of(10, 0);
            String message = now.isBefore(cutoffTime) ? "Votre demande sera trait\u00e9e aujourd'hui \u00e0 11h10 (pensez \u00e0 valider avant 11h10)" : "Votre demande sera trait\u00e9e demain \u00e0 11h10 (pensez \u00e0 valider avant 11h10)";
            response.put("success", true);
            response.put("message", message);
            response.put("persoId", persoId);
            response.put("rib", newRib);
            response.put("enAttente", true);
            System.out.println("\u2705 Demande RIB cr\u00e9\u00e9e - EXPORTED='N'");
            System.out.println("   PersoId: " + persoId);
            System.out.println("   Heure: " + now);
            return response;
        }
        catch (Exception e) {
            System.err.println("\u274c Erreur: " + e.getMessage());
            e.printStackTrace();
            HashMap<String, Object> errorResponse = new HashMap<String, Object>();
            errorResponse.put("success", false);
            errorResponse.put("message", "Erreur lors de la demande");
            return errorResponse;
        }
    }

    @Transactional
    public void traiterDemandesRibEnAttente() {
        try {
            System.out.println("========================================");
            System.out.println("\ud83d\udd04 TRAITEMENT AUTOMATIQUE DES RIBs");
            System.out.println("\ud83d\udd59 Heure actuelle: " + LocalTime.now());
            System.out.println("========================================");
            LocalTime cutoffTime = LocalTime.of(11, 10);
            LocalDateTime now = LocalDateTime.now();
            LocalDate today = now.toLocalDate();
            List<Rib> demandesValidees = this.ribRepository.findByExported("Y");
            System.out.println("\ud83d\udccb Demandes trouv\u00e9es avec EXPORTED='Y': " + demandesValidees.size());
            if (demandesValidees.isEmpty()) {
                System.out.println("\u2139\ufe0f Aucune demande valid\u00e9e (EXPORTED='Y')");
                return;
            }
            int compteurTraitees = 0;
            int compteurIgnorees = 0;
            int compteurEchecs = 0;
            for (Rib demande : demandesValidees) {
                try {
                    boolean creeAvant11h10;
                    System.out.println("----------------------------------------");
                    System.out.println("   \ud83d\udce6 Analyse demande #" + demande.getNumRib());
                    System.out.println("   \ud83d\udc64 PersoId: " + demande.getPersoId());
                    System.out.println("   \ud83d\udfe2 EXPORTED: " + demande.getExported());
                    LocalDateTime creationDateTime = demande.getDateCreation().toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
                    LocalTime creationTime = creationDateTime.toLocalTime();
                    LocalDate creationDate = creationDateTime.toLocalDate();
                    System.out.println("   \ud83d\udcc5 Date cr\u00e9ation: " + creationDate);
                    System.out.println("   \ud83d\udd50 Heure cr\u00e9ation: " + creationTime);
                    boolean bl = creeAvant11h10 = creationDate.equals(today) && creationTime.isBefore(cutoffTime);
                    if (!creeAvant11h10) {
                        System.out.println("   \u23ed\ufe0f IGNOR\u00c9 - Demande cr\u00e9\u00e9e apr\u00e8s 11h10 ou pas aujourd'hui");
                        System.out.println("   \u2139\ufe0f Sera trait\u00e9e demain \u00e0 11h10");
                        ++compteurIgnorees;
                        continue;
                    }
                    System.out.println("   \u2705 CONDITIONS VALID\u00c9ES - Traitement en cours");
                    Optional<User> userOpt = this.userRepository.findByPersoId(demande.getPersoId());
                    if (userOpt.isPresent()) {
                        User user = userOpt.get();
                        System.out.println("   \ud83d\udccc RIB actuel: " + user.getRib());
                        System.out.println("   \u2728 Nouveau RIB: " + demande.getNouveauRib());
                        user.setRib(demande.getNouveauRib());
                        this.userRepository.save(user);
                        System.out.println("   \u2705 RIB mis \u00e0 jour dans users");
                        demande.setExported("PROCESSED");
                        this.ribRepository.save(demande);
                        System.out.println("   \u2705 Demande marqu\u00e9e comme trait\u00e9e");
                        ++compteurTraitees;
                        continue;
                    }
                    System.err.println("   \u26a0\ufe0f Utilisateur non trouv\u00e9: " + demande.getPersoId());
                    ++compteurEchecs;
                }
                catch (Exception e) {
                    System.err.println("   \u274c Erreur: " + e.getMessage());
                    e.printStackTrace();
                    ++compteurEchecs;
                }
            }
            System.out.println("========================================");
            System.out.println("\u2705 TRAITEMENT TERMIN\u00c9");
            System.out.println("   \u2714\ufe0f Trait\u00e9es: " + compteurTraitees);
            System.out.println("   \u23ed\ufe0f Ignor\u00e9es (apr\u00e8s 11h10): " + compteurIgnorees);
            System.out.println("   \u274c \u00c9checs: " + compteurEchecs);
            System.out.println("   \ud83d\udcca Total analys\u00e9es: " + demandesValidees.size());
            System.out.println("========================================");
        }
        catch (Exception e) {
            System.err.println("\u274c ERREUR GLOBALE: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public List<User> getAllUsers() {
        return this.userRepository.findAll();
    }

    public Optional<User> getUserById(String id) {
        return this.userRepository.findById(id);
    }

    public String getContactByPersoId(String persoId) {
        try {
            return this.userRepository.findContactByPersoId(persoId);
        }
        catch (Exception e) {
            System.err.println("\u274c Erreur contact: " + e.getMessage());
            return null;
        }
    }

    public boolean updateContact(String persoId, String newContact) {
        try {
            Optional<User> userOpt = this.userRepository.findByPersoId(persoId);
            if (userOpt.isPresent()) {
                User user = userOpt.get();
                user.setContact(newContact);
                this.userRepository.save(user);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            System.err.println("\u274c Erreur: " + e.getMessage());
            return false;
        }
    }

    public List<User> getUsersByCompany(String codeEntreprise) {
        try {
            return this.userRepository.findByCodeEntreprise(codeEntreprise);
        }
        catch (Exception e) {
            System.err.println("\u274c Erreur lors de la r\u00e9cup\u00e9ration des utilisateurs de l'entreprise " + codeEntreprise + ": " + e.getMessage());
            return new ArrayList<User>();
        }
    }

    public Map<String, Object> getContactByPersoIdV2(String persoId) {
        try {
            HashMap<String, Object> response = new HashMap<String, Object>();
            Optional<User> userOpt = this.userRepository.findByPersoId(persoId);
            if (!userOpt.isPresent()) {
                throw new RuntimeException("Utilisateur non trouv\u00e9");
            }
            User user = userOpt.get();
            String contactActuel = user.getContact();
            List<Tel> telsEnAttente = this.telRepository.findByPersoIdAndExported(persoId, "N");
            if (!telsEnAttente.isEmpty()) {
                Tel telEnAttente = telsEnAttente.get(0);
                response.put("persoId", persoId);
                response.put("contact", telEnAttente.getNouveauTel());
                response.put("ancienContact", telEnAttente.getAncienTel());
                response.put("enAttente", true);
                LocalTime now = LocalTime.now();
                LocalTime cutoffTime = LocalTime.of(11, 10);
                LocalDateTime creationDateTime = telEnAttente.getDateCreation().toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
                LocalTime creationTime = creationDateTime.toLocalTime();
                LocalDate creationDate = creationDateTime.toLocalDate();
                LocalDate today = LocalDate.now();
                String message = creationDate.equals(today) && creationTime.isBefore(cutoffTime) && now.isBefore(cutoffTime) ? "Votre t\u00e9l\u00e9phone sera modifi\u00e9 aujourd'hui \u00e0 11h10" : "Votre t\u00e9l\u00e9phone sera modifi\u00e9 demain \u00e0 11h10";
                response.put("message", message);
                System.out.println("\ud83d\udcf1 T\u00e9l\u00e9phone en attente trouv\u00e9 pour " + persoId);
                System.out.println("   Ancien: " + telEnAttente.getAncienTel());
                System.out.println("   Nouveau: " + telEnAttente.getNouveauTel());
                System.out.println("   Cr\u00e9\u00e9 \u00e0: " + creationTime);
            } else {
                response.put("persoId", persoId);
                response.put("contact", contactActuel != null ? contactActuel : "");
                response.put("enAttente", false);
                System.out.println("\ud83d\udcf1 Contact actif retourn\u00e9 pour " + persoId + ": " + contactActuel);
            }
            return response;
        }
        catch (Exception e) {
            System.err.println("\u274c Erreur lors de la r\u00e9cup\u00e9ration du contact pour " + persoId + ": " + e.getMessage());
            throw new RuntimeException("Erreur lors de la r\u00e9cup\u00e9ration du contact", e);
        }
    }

    @Transactional
    public Map<String, Object> updateContactV2(String persoId, String newContact) {
        try {
            HashMap<String, Object> response = new HashMap<String, Object>();
            Optional<User> userOpt = this.userRepository.findByPersoId(persoId);
            if (!userOpt.isPresent()) {
                response.put("success", false);
                response.put("message", "Utilisateur non trouv\u00e9");
                return response;
            }
            User user = userOpt.get();
            String ancienContact = user.getContact();
            if (newContact.equals(ancienContact)) {
                response.put("success", false);
                response.put("message", "Le nouveau t\u00e9l\u00e9phone est identique \u00e0 l'ancien");
                return response;
            }
            List<Tel> demandesExistantes = this.telRepository.findByPersoIdAndExported(persoId, "N");
            if (!demandesExistantes.isEmpty()) {
                response.put("success", false);
                response.put("message", "Vous avez d\u00e9j\u00e0 une demande de changement de t\u00e9l\u00e9phone en cours");
                return response;
            }
            Tel nouvelleDemandeTel = new Tel();
            nouvelleDemandeTel.setPersoId(persoId);
            nouvelleDemandeTel.setAncienTel(ancienContact);
            nouvelleDemandeTel.setNouveauTel(newContact);
            nouvelleDemandeTel.setExported("N");
            nouvelleDemandeTel.setDateCreation(new Date());
            this.telRepository.save(nouvelleDemandeTel);
            LocalTime now = LocalTime.now();
            LocalTime cutoffTime = LocalTime.of(11, 10);
            String message = now.isBefore(cutoffTime) ? "Votre demande sera trait\u00e9e aujourd'hui \u00e0 11h10 (pensez \u00e0 valider avant 11h10)" : "Votre demande sera trait\u00e9e demain \u00e0 11h10 (pensez \u00e0 valider avant 11h10)";
            response.put("success", true);
            response.put("message", message);
            response.put("persoId", persoId);
            response.put("contact", newContact);
            response.put("enAttente", true);
            System.out.println("\u2705 Demande t\u00e9l\u00e9phone cr\u00e9\u00e9e - EXPORTED='N'");
            System.out.println("   PersoId: " + persoId);
            System.out.println("   Heure: " + now);
            return response;
        }
        catch (Exception e) {
            System.err.println("\u274c Erreur: " + e.getMessage());
            e.printStackTrace();
            HashMap<String, Object> errorResponse = new HashMap<String, Object>();
            errorResponse.put("success", false);
            errorResponse.put("message", "Erreur lors de la demande");
            return errorResponse;
        }
    }

    @Transactional
    public void traiterDemandesTelEnAttente() {
        try {
            System.out.println("========================================");
            System.out.println("\ud83d\udcf1 TRAITEMENT AUTOMATIQUE DES T\u00c9L\u00c9PHONES");
            System.out.println("\ud83d\udd59 Heure actuelle: " + LocalTime.now());
            System.out.println("========================================");
            LocalTime cutoffTime = LocalTime.of(11, 10);
            LocalDateTime now = LocalDateTime.now();
            LocalDate today = now.toLocalDate();
            List<Tel> demandesValidees = this.telRepository.findByExported("Y");
            System.out.println("\ud83d\udccb Demandes trouv\u00e9es avec EXPORTED='Y': " + demandesValidees.size());
            if (demandesValidees.isEmpty()) {
                System.out.println("\u2139\ufe0f Aucune demande valid\u00e9e (EXPORTED='Y')");
                return;
            }
            int compteurTraitees = 0;
            int compteurIgnorees = 0;
            int compteurEchecs = 0;
            for (Tel demande : demandesValidees) {
                try {
                    boolean creeAvant11h10;
                    System.out.println("----------------------------------------");
                    System.out.println("   \ud83d\udce6 Analyse demande #" + demande.getNumTel());
                    System.out.println("   \ud83d\udc64 PersoId: " + demande.getPersoId());
                    System.out.println("   \ud83d\udfe2 EXPORTED: " + demande.getExported());
                    LocalDateTime creationDateTime = demande.getDateCreation().toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
                    LocalTime creationTime = creationDateTime.toLocalTime();
                    LocalDate creationDate = creationDateTime.toLocalDate();
                    System.out.println("   \ud83d\udcc5 Date cr\u00e9ation: " + creationDate);
                    System.out.println("   \ud83d\udd50 Heure cr\u00e9ation: " + creationTime);
                    boolean bl = creeAvant11h10 = creationDate.equals(today) && creationTime.isBefore(cutoffTime);
                    if (!creeAvant11h10) {
                        System.out.println("   \u23ed\ufe0f IGNOR\u00c9 - Demande cr\u00e9\u00e9e apr\u00e8s 11h10 ou pas aujourd'hui");
                        System.out.println("   \u2139\ufe0f Sera trait\u00e9e demain \u00e0 11h10");
                        ++compteurIgnorees;
                        continue;
                    }
                    System.out.println("   \u2705 CONDITIONS VALID\u00c9ES - Traitement en cours");
                    Optional<User> userOpt = this.userRepository.findByPersoId(demande.getPersoId());
                    if (userOpt.isPresent()) {
                        User user = userOpt.get();
                        System.out.println("   \ud83d\udccc Contact actuel: " + user.getContact());
                        System.out.println("   \u2728 Nouveau contact: " + demande.getNouveauTel());
                        user.setContact(demande.getNouveauTel());
                        this.userRepository.save(user);
                        System.out.println("   \u2705 Contact mis \u00e0 jour dans users");
                        demande.setExported("PROCESSED");
                        this.telRepository.save(demande);
                        System.out.println("   \u2705 Demande marqu\u00e9e comme trait\u00e9e");
                        ++compteurTraitees;
                        continue;
                    }
                    System.err.println("   \u26a0\ufe0f Utilisateur non trouv\u00e9: " + demande.getPersoId());
                    ++compteurEchecs;
                }
                catch (Exception e) {
                    System.err.println("   \u274c Erreur: " + e.getMessage());
                    e.printStackTrace();
                    ++compteurEchecs;
                }
            }
            System.out.println("========================================");
            System.out.println("\u2705 TRAITEMENT TERMIN\u00c9");
            System.out.println("   \u2714\ufe0f Trait\u00e9es: " + compteurTraitees);
            System.out.println("   \u23ed\ufe0f Ignor\u00e9es (apr\u00e8s 11h10): " + compteurIgnorees);
            System.out.println("   \u274c \u00c9checs: " + compteurEchecs);
            System.out.println("   \ud83d\udcca Total analys\u00e9es: " + demandesValidees.size());
            System.out.println("========================================");
        }
        catch (Exception e) {
            System.err.println("\u274c ERREUR GLOBALE: " + e.getMessage());
            e.printStackTrace();
        }
    }
}

