/*
 * Decompiled with CFR 0.152.
 */
package com.smldb2.csvimporter;

import com.opencsv.CSVReader;
import java.io.FileReader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;

public class CsvImporter {
    private static final String DB_URL = "jdbc:mysql://localhost:3306/mybs?useSSL=false&allowPublicKeyRetrieval=true&serverTimezone=UTC";
    private static final String DB_USER = "root";
    private static final String DB_PASSWORD = "";
    private static final String CLIENTS_CSV = "C:/csv/clients.csv";
    private static final String STAT_ACT_ANN_CSV = "C:/csv/stat_act_ann.csv";
    private static final String STAT_ACT_DATE_CSV = "C:/csv/stat_act_date.csv";

    public static void main(String[] args) {
        System.out.println("\ud83d\ude80 D\u00e9marrage de l'import CSV...");
        System.out.println("========================================");
        CsvImporter importer = new CsvImporter();
        try {
            System.out.println("\n\ud83d\udcc1 Import du fichier CLIENTS...");
            importer.importClients();
            System.out.println("\n\ud83d\udcc1 Import du fichier STAT_ACT_ANN...");
            importer.importStatActAnn();
            System.out.println("\n\ud83d\udcc1 Import du fichier STAT_ACT_DATE...");
            importer.importStatActDate();
            System.out.println("\n========================================");
            System.out.println("\u2705 Tous les imports sont termin\u00e9s avec succ\u00e8s!");
        }
        catch (Exception e) {
            System.err.println("\u274c Erreur lors de l'import : " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void importClients() throws Exception {
        Connection conn = null;
        try {
            Class.forName("com.mysql.cj.jdbc.Driver");
            conn = DriverManager.getConnection(DB_URL, DB_USER, DB_PASSWORD);
            conn.setAutoCommit(false);
            System.out.println("\ud83d\udcca Connexion \u00e0 la base de donn\u00e9es \u00e9tablie");
            try (CSVReader reader = new CSVReader(new FileReader(CLIENTS_CSV));){
                String[] line;
                reader.readNext();
                HashSet<String> csvCodes = new HashSet<String>();
                String checkQuery = "SELECT COUNT(*) FROM clients WHERE codeClt = ?";
                String updateQuery = "UPDATE clients SET description = ?, numContrat = ? WHERE codeClt = ?";
                String insertQuery = "INSERT INTO clients (codeClt, description, numContrat) VALUES (?, ?, ?)";
                PreparedStatement checkStmt = conn.prepareStatement(checkQuery);
                PreparedStatement updateStmt = conn.prepareStatement(updateQuery);
                PreparedStatement insertStmt = conn.prepareStatement(insertQuery);
                int insertCount = 0;
                int updateCount = 0;
                while ((line = reader.readNext()) != null) {
                    String codeClt = line[0].trim();
                    String description = line[1].trim();
                    String numContrat = line[2].trim();
                    csvCodes.add(codeClt);
                    checkStmt.setString(1, codeClt);
                    ResultSet rs = checkStmt.executeQuery();
                    rs.next();
                    boolean exists = rs.getInt(1) > 0;
                    rs.close();
                    if (exists) {
                        updateStmt.setString(1, description);
                        updateStmt.setString(2, numContrat);
                        updateStmt.setString(3, codeClt);
                        updateStmt.executeUpdate();
                        ++updateCount;
                        continue;
                    }
                    insertStmt.setString(1, codeClt);
                    insertStmt.setString(2, description);
                    insertStmt.setString(3, numContrat);
                    insertStmt.executeUpdate();
                    ++insertCount;
                }
                System.out.println("\u2795 Nouveaux clients ajout\u00e9s : " + insertCount);
                System.out.println("\ud83d\udd04 Clients mis \u00e0 jour : " + updateCount);
                String selectAllQuery = "SELECT codeClt FROM clients";
                Statement selectStmt = conn.createStatement();
                ResultSet allClients = selectStmt.executeQuery(selectAllQuery);
                String deleteQuery = "DELETE FROM clients WHERE codeClt = ?";
                PreparedStatement deleteStmt = conn.prepareStatement(deleteQuery);
                int deleteCount = 0;
                while (allClients.next()) {
                    String codeClt = allClients.getString("codeClt");
                    if (csvCodes.contains(codeClt)) continue;
                    deleteStmt.setString(1, codeClt);
                    deleteStmt.executeUpdate();
                    ++deleteCount;
                }
                System.out.println("\ud83d\uddd1\ufe0f Clients supprim\u00e9s : " + deleteCount);
                conn.commit();
                checkStmt.close();
                updateStmt.close();
                insertStmt.close();
                deleteStmt.close();
                selectStmt.close();
                allClients.close();
            }
        }
        catch (SQLException e) {
            if (conn != null) {
                try {
                    conn.rollback();
                    System.err.println("\u26a0\ufe0f Transaction annul\u00e9e");
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                }
            }
            throw e;
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                    System.out.println("\ud83d\udd0c Connexion ferm\u00e9e");
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void importStatActAnn() throws Exception {
        Connection conn = null;
        try {
            Class.forName("com.mysql.cj.jdbc.Driver");
            conn = DriverManager.getConnection(DB_URL, DB_USER, DB_PASSWORD);
            conn.setAutoCommit(false);
            System.out.println("\ud83d\udcca Connexion \u00e0 la base de donn\u00e9es \u00e9tablie");
            try (CSVReader reader = new CSVReader(new FileReader(STAT_ACT_ANN_CSV));){
                String[] line;
                reader.readNext();
                String deleteAllQuery = "DELETE FROM stat_act_ann";
                Statement deleteStmt = conn.createStatement();
                int deletedRows = deleteStmt.executeUpdate(deleteAllQuery);
                System.out.println("\ud83d\uddd1\ufe0f Anciennes donn\u00e9es supprim\u00e9es : " + deletedRows);
                deleteStmt.close();
                String insertQuery = "INSERT INTO stat_act_ann (annee, codesociete, acte, depense, rembourser) VALUES (?, ?, ?, ?, ?)";
                PreparedStatement insertStmt = conn.prepareStatement(insertQuery);
                int insertCount = 0;
                int errorCount = 0;
                while ((line = reader.readNext()) != null) {
                    try {
                        if (line.length < 5) continue;
                        String anneeStr = line[0].trim();
                        Integer annee = anneeStr.isEmpty() ? null : Integer.valueOf(Integer.parseInt(anneeStr));
                        String codeSociete = line[1].trim();
                        String acte = line[2].trim();
                        String depenseStr = line[3].trim();
                        Double depense = depenseStr.isEmpty() ? null : Double.valueOf(Double.parseDouble(depenseStr.replace(",", ".")));
                        String rembourserStr = line[4].trim();
                        Double rembourser = rembourserStr.isEmpty() ? null : Double.valueOf(Double.parseDouble(rembourserStr.replace(",", ".")));
                        insertStmt.setObject(1, annee);
                        insertStmt.setString(2, codeSociete);
                        insertStmt.setString(3, acte);
                        insertStmt.setObject(4, depense);
                        insertStmt.setObject(5, rembourser);
                        insertStmt.executeUpdate();
                        if (++insertCount % 100 != 0) continue;
                        System.out.println("\u23f3 " + insertCount + " lignes trait\u00e9es...");
                    }
                    catch (Exception e) {
                        System.err.println("\u26a0\ufe0f Erreur ligne " + (insertCount + ++errorCount) + " : " + e.getMessage());
                    }
                }
                System.out.println("\u2795 Lignes ins\u00e9r\u00e9es avec succ\u00e8s : " + insertCount);
                if (errorCount > 0) {
                    System.out.println("\u274c Lignes en erreur : " + errorCount);
                }
                conn.commit();
                insertStmt.close();
            }
        }
        catch (SQLException e) {
            if (conn != null) {
                try {
                    conn.rollback();
                    System.err.println("\u26a0\ufe0f Transaction annul\u00e9e");
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                }
            }
            throw e;
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                    System.out.println("\ud83d\udd0c Connexion ferm\u00e9e");
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void importStatActDate() throws Exception {
        Connection conn = null;
        try {
            Class.forName("com.mysql.cj.jdbc.Driver");
            conn = DriverManager.getConnection(DB_URL, DB_USER, DB_PASSWORD);
            conn.setAutoCommit(false);
            System.out.println("\ud83d\udcca Connexion \u00e0 la base de donn\u00e9es \u00e9tablie");
            try (CSVReader reader = new CSVReader(new FileReader(STAT_ACT_DATE_CSV));){
                String[] line;
                Object insertQuery;
                boolean formatCorrect;
                CharSequence[] headers = reader.readNext();
                System.out.println("\ud83d\udccb Colonnes d\u00e9tect\u00e9es : " + String.join((CharSequence)", ", headers));
                String deleteAllQuery = "DELETE FROM stat_act_date";
                Statement deleteStmt = conn.createStatement();
                int deletedRows = deleteStmt.executeUpdate(deleteAllQuery);
                System.out.println("\ud83d\uddd1\ufe0f Anciennes donn\u00e9es supprim\u00e9es : " + deletedRows);
                deleteStmt.close();
                boolean bl = formatCorrect = headers.length >= 6 && ((String)headers[0]).trim().equalsIgnoreCase("date_bs") && ((String)headers[1]).trim().equalsIgnoreCase("code_societe") && ((String)headers[2]).trim().equalsIgnoreCase("acte") && ((String)headers[3]).trim().equalsIgnoreCase("depense") && ((String)headers[4]).trim().equalsIgnoreCase("rembourse") && ((String)headers[5]).trim().equalsIgnoreCase("matricule");
                if (formatCorrect) {
                    insertQuery = "INSERT INTO stat_act_date (date_bs, code_societe, acte, depense, rembourse, matricule) VALUES (?, ?, ?, ?, ?, ?)";
                    System.out.println("\u2705 Format CSV correct d\u00e9tect\u00e9");
                } else {
                    System.out.println("\u26a0\ufe0f Format CSV diff\u00e9rent, utilisation du format dynamique");
                    StringBuilder insertQueryBuilder = new StringBuilder("INSERT INTO stat_act_date (");
                    StringBuilder valuesQuery = new StringBuilder(" VALUES (");
                    for (int i = 0; i < headers.length; ++i) {
                        if (i > 0) {
                            insertQueryBuilder.append(", ");
                            valuesQuery.append(", ");
                        }
                        insertQueryBuilder.append("`").append(((String)headers[i]).trim()).append("`");
                        valuesQuery.append("?");
                    }
                    insertQueryBuilder.append(")");
                    valuesQuery.append(")");
                    insertQuery = insertQueryBuilder.toString() + valuesQuery.toString();
                }
                System.out.println("\ud83d\udcdd Requ\u00eate SQL : " + (String)insertQuery);
                PreparedStatement insertStmt = conn.prepareStatement((String)insertQuery);
                int insertCount = 0;
                int errorCount = 0;
                while ((line = reader.readNext()) != null) {
                    try {
                        if (line.length >= headers.length) {
                            for (int i = 0; i < headers.length; ++i) {
                                String value = line[i].trim();
                                if (i == 3 || i == 4) {
                                    value = value.replace(",", ".");
                                }
                                insertStmt.setString(i + 1, value);
                            }
                            insertStmt.executeUpdate();
                            if (++insertCount % 500 != 0) continue;
                            System.out.println("\u23f3 " + insertCount + " lignes trait\u00e9es...");
                            continue;
                        }
                        System.err.println("\u26a0\ufe0f Ligne " + (insertCount + ++errorCount) + " ignor\u00e9e : nombre de colonnes insuffisant");
                    }
                    catch (Exception e) {
                        System.err.println("\u26a0\ufe0f Erreur ligne " + (insertCount + ++errorCount) + " : " + e.getMessage());
                    }
                }
                System.out.println("\u2795 Lignes ins\u00e9r\u00e9es avec succ\u00e8s : " + insertCount);
                if (errorCount > 0) {
                    System.out.println("\u274c Lignes en erreur : " + errorCount);
                }
                conn.commit();
                insertStmt.close();
            }
        }
        catch (SQLException e) {
            if (conn != null) {
                try {
                    conn.rollback();
                    System.err.println("\u26a0\ufe0f Transaction annul\u00e9e");
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                }
            }
            throw e;
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                    System.out.println("\ud83d\udd0c Connexion ferm\u00e9e");
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

